/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.util.exception.InvalidInputException;

public class HighLabelSymbol
extends HighSymbol {
    public HighLabelSymbol(String nm, Address addr, PcodeDataTypeManager dtmanage) {
        super(0L, nm, DataType.DEFAULT, true, true, dtmanage);
        VariableStorage store;
        try {
            store = new VariableStorage(this.getProgram(), addr, 1);
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
        }
        MappedEntry entry = new MappedEntry(this, store, null);
        this.addMapEntry(entry);
    }

    @Override
    public void saveXML(StringBuilder buf) {
        buf.append("<labelsym");
        this.saveXMLHeader(buf);
        buf.append("/>\n");
    }
}

