/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.GIFResource;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Resource;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import javax.swing.ImageIcon;

public class GifDataType
extends BuiltIn
implements Dynamic,
Resource {
    public static byte[] MAGIC_87 = new byte[]{71, 73, 70, 56, 55, 97};
    public static byte[] MAGIC_89 = new byte[]{71, 73, 70, 56, 57, 97};
    public static byte[] GIFMASK = new byte[]{-1, -1, -1, -1, -1, -1};

    public GifDataType() {
        this(null);
    }

    public GifDataType(DataTypeManager dtm) {
        super(null, "GIF-Image", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try {
            try {
                GIFResource gif = new GIFResource(buf);
                return gif.getLength();
            }
            catch (InvalidDataTypeException e) {
                Msg.error((Object)this, (Object)("Invalid GIF data at " + buf.getAddress()));
                return -1;
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Invalid GIF data at " + buf.getAddress()));
            return -1;
        }
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new GifDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "GIF Image stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "GIF";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<GIF-Image>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            return null;
        }
        return new GifDataImage(data);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return GifDataImage.class;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "GIF";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    private static class GifDataImage
    extends DataImage {
        private final byte[] data;

        GifDataImage(byte[] data) {
            this.data = data;
        }

        @Override
        public ImageIcon getImageIcon() {
            return new ImageIcon(this.data, "<GIF-Image>");
        }

        @Override
        public String getImageFileType() {
            return "gif";
        }
    }
}

