/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.pattern.ContextPattern;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.InstructionPattern;
import ghidra.app.plugin.processors.sleigh.pattern.OrPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class CombinePattern
extends DisjointPattern {
    private ContextPattern context;
    private InstructionPattern instr;

    @Override
    public PatternBlock getBlock(boolean cont) {
        return cont ? this.context.getBlock() : this.instr.getBlock();
    }

    public CombinePattern() {
        this.context = null;
        this.instr = null;
    }

    public CombinePattern(ContextPattern con, InstructionPattern in) {
        this.context = con;
        this.instr = in;
    }

    @Override
    public Pattern simplifyClone() {
        if (this.context.alwaysTrue()) {
            return this.instr.simplifyClone();
        }
        if (this.instr.alwaysTrue()) {
            return this.context.simplifyClone();
        }
        if (this.context.alwaysFalse() || this.instr.alwaysFalse()) {
            return new InstructionPattern(false);
        }
        return new CombinePattern((ContextPattern)this.context.simplifyClone(), (InstructionPattern)this.instr.simplifyClone());
    }

    @Override
    public void shiftInstruction(int sa) {
        this.instr.shiftInstruction(sa);
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (b.numDisjoint() != 0) {
            return b.doOr(this, -sa);
        }
        DisjointPattern res1 = (DisjointPattern)this.simplifyClone();
        DisjointPattern res2 = (DisjointPattern)b.simplifyClone();
        if (sa < 0) {
            res1.shiftInstruction(-sa);
        } else {
            res2.shiftInstruction(sa);
        }
        OrPattern tmp = new OrPattern(res1, res2);
        return tmp;
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        CombinePattern tmp;
        if (b.numDisjoint() != 0) {
            return b.doAnd(this, -sa);
        }
        if (b instanceof CombinePattern) {
            ContextPattern c = (ContextPattern)this.context.doAnd(((CombinePattern)b).context, 0);
            InstructionPattern i = (InstructionPattern)this.instr.doAnd(((CombinePattern)b).instr, sa);
            tmp = new CombinePattern(c, i);
        } else if (b instanceof InstructionPattern) {
            InstructionPattern i = (InstructionPattern)this.instr.doAnd(b, sa);
            tmp = new CombinePattern((ContextPattern)this.context.simplifyClone(), i);
        } else {
            ContextPattern c = (ContextPattern)this.context.doAnd(b, 0);
            InstructionPattern newpat = (InstructionPattern)this.instr.simplifyClone();
            if (sa < 0) {
                newpat.shiftInstruction(-sa);
            }
            tmp = new CombinePattern(c, newpat);
        }
        return tmp;
    }

    @Override
    public boolean isMatch(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        this.debugNextMatch(debug, true);
        boolean match = this.instr.isMatch(walker, debug);
        this.debugNextMatch(debug, false);
        if (match || debug != null) {
            match &= this.context.isMatch(walker, debug);
        }
        this.debugDone(debug, match);
        return match;
    }

    private void debugDone(SleighDebugLogger debug, boolean match) {
        if (debug != null) {
            debug.endPatternGroup(match);
            debug.dropIndent();
            debug.append(") " + (match ? "Matched" : "Failed") + "\n");
        }
    }

    private void debugNextMatch(SleighDebugLogger debug, boolean isFirst) {
        if (debug == null) {
            return;
        }
        if (isFirst) {
            debug.startPatternGroup(null);
            debug.append("(  ");
        } else {
            debug.dropIndent();
            debug.append(") -and- (\n");
        }
        debug.indent();
    }

    @Override
    public boolean alwaysTrue() {
        return this.context.alwaysTrue() && this.instr.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.context.alwaysFalse() || this.instr.alwaysFalse();
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return this.instr.alwaysInstructionTrue();
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"combine_pat"});
        this.context = new ContextPattern();
        this.context.restoreXml(parser);
        this.instr = new InstructionPattern();
        this.instr.restoreXml(parser);
        parser.end(el);
    }

    public String toString() {
        if (this.context.alwaysTrue()) {
            return this.instr.toString();
        }
        if (this.instr.alwaysTrue()) {
            return this.context.toString();
        }
        if (this.context.alwaysFalse() || this.instr.alwaysFalse()) {
            return "never";
        }
        return "cmb:(" + this.context + "," + this.instr + ")";
    }
}

