/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatConstants;
import ghidra.file.formats.android.vdex.DexSectionHeader_002;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexConstants;
import ghidra.file.formats.android.vdex.VdexFactory;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.VdexStringTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class VdexHeaderAnalyzer
extends FileFormatAnalyzer {
    private static final DataType BYTE = new ByteDataType();

    public String getName() {
        return "Android VDEX Header Format";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Annotates the Android VDEX data in this program.";
    }

    public boolean canAnalyze(Program program) {
        return VdexConstants.isVDEX(program) || OatConstants.isOAT(program);
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = VdexConstants.findVDEX(program);
        if (address == null) {
            log.appendMsg(this.getClass().getSimpleName() + " - no vdex header found in memory, skipping");
            return true;
        }
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        try {
            VdexHeader vdexHeader = VdexFactory.getVdexHeader(reader);
            vdexHeader.parse(reader, monitor);
            DataType vdexHeaderDataType = vdexHeader.toDataType();
            this.createData(program, address, vdexHeaderDataType);
            address = address.add((long)vdexHeaderDataType.getLength());
            if (!vdexHeader.isDexHeaderEmbeddedInDataType()) {
                for (int i = 0; i < vdexHeader.getDexHeaderList().size(); ++i) {
                    monitor.checkCanceled();
                    program.getListing().setComment(address, 3, "quicken info table entry");
                    this.createData(program, address, (DataType)new DWordDataType());
                    address = address.add(4L);
                    DexHeader dexHeader = vdexHeader.getDexHeaderList().get(i);
                    DataType dexHeaderDataType = dexHeader.toDataType();
                    this.createData(program, address, dexHeaderDataType);
                    int size = dexHeader.getFileSize() - dexHeaderDataType.getLength();
                    ArrayDataType array = new ArrayDataType(BYTE, size, BYTE.getLength());
                    this.createData(program, address.add((long)dexHeaderDataType.getLength()), (DataType)array);
                    address = address.add((long)dexHeader.getFileSize());
                }
            }
            address = this.createDexSharedDataSize(program, address, vdexHeader);
            address = this.createVerifierDepsSize(program, address, vdexHeader);
            address = this.createQuickeningInfoSize(program, address, vdexHeader);
            return true;
        }
        catch (UnsupportedVdexVersionException e) {
            log.appendMsg(e.getMessage());
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
        return false;
    }

    private Address createDexSharedDataSize(Program program, Address address, VdexHeader vdexHeader) throws Exception {
        DexSectionHeader_002 sectionHeader = vdexHeader.getDexSectionHeader_002();
        if (sectionHeader != null) {
            int dexSharedDataSize = sectionHeader.getDexSharedDataSize();
            String comment = "dex_shared_data_size_ : 0x" + Integer.toHexString(dexSharedDataSize);
            program.getListing().setComment(address, 3, comment);
            ArrayDataType array = new ArrayDataType(BYTE, dexSharedDataSize, BYTE.getLength());
            this.createData(program, address, (DataType)array);
            address = address.add((long)dexSharedDataSize);
        }
        return address;
    }

    private Address createVerifierDepsSize(Program program, Address address, VdexHeader vdexHeader) throws Exception {
        if (vdexHeader.getVerifierDepsVersion() != "021") {
            return address;
        }
        String comment = "verifier_deps_size_ : 0x" + Integer.toHexString(vdexHeader.getVerifierDepsSize());
        program.getListing().setComment(address, 3, comment);
        int remainderSize = vdexHeader.getVerifierDepsSize();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), address);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, !program.getLanguage().isBigEndian());
        VdexStringTable stringTable = new VdexStringTable(reader);
        if (stringTable.getStringCount() > 0) {
            this.createData(program, address, stringTable.toDataType());
            address = address.add((long)stringTable.getSize());
            remainderSize -= stringTable.getSize();
        }
        if (address.add((long)remainderSize).compareTo((Object)program.getMaxAddress()) > 0) {
            remainderSize = (int)program.getMaxAddress().subtract(address);
        }
        if (remainderSize > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, remainderSize, BYTE.getLength());
            this.createData(program, address, (DataType)array);
            address = address.add((long)remainderSize);
        }
        return address;
    }

    private Address createQuickeningInfoSize(Program program, Address address, VdexHeader vdexHeader) throws Exception {
        int quickeningInfoSize = vdexHeader.getQuickeningInfoSize();
        DexSectionHeader_002 sectionHeader = vdexHeader.getDexSectionHeader_002();
        if (sectionHeader != null) {
            quickeningInfoSize = sectionHeader.getQuickeningInfoSize();
        }
        if (quickeningInfoSize == 0) {
            return address;
        }
        String comment = "quickening_info_size_ : 0x" + Integer.toHexString(quickeningInfoSize);
        program.getListing().setComment(address, 3, comment);
        address = address.add((long)quickeningInfoSize);
        return address;
    }
}

