/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.bundle;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.art.ArtFactory;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.UnsupportedArtVersionException;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.bundle.OatBundle;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexFactory;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class FullOatBundle
implements OatBundle {
    private Program oatProgram;
    private OatHeader oatHeader;
    private VdexHeader vdexHeader;
    private ArtHeader artHeader;
    private List<DexHeader> dexHeaders = new ArrayList<DexHeader>();
    private Map<Integer, DexHeader> dexHeadersMap = new HashMap<Integer, DexHeader>();
    private boolean isLittleEndian;

    FullOatBundle(Program oatProgram, OatHeader oatHeader, TaskMonitor monitor, MessageLog log) {
        this.oatProgram = oatProgram;
        this.oatHeader = oatHeader;
        this.isLittleEndian = !oatProgram.getLanguage().isBigEndian();
        this.loadVdexHeader(oatProgram, monitor, log);
        this.loadDexHeaders(oatProgram, monitor, log);
        this.loadArtHeader(oatProgram, monitor, log);
    }

    @Override
    public void close() {
        this.oatProgram = null;
        this.oatHeader = null;
        this.vdexHeader = null;
        this.artHeader = null;
        this.dexHeaders.clear();
        this.dexHeadersMap.clear();
    }

    @Override
    public DexHeader getDexHeaderByChecksum(int checksum) {
        for (DexHeader dexHeader : this.dexHeaders) {
            if (dexHeader.getChecksum() != checksum) continue;
            return dexHeader;
        }
        if (this.vdexHeader != null) {
            for (int i = 0; i < this.vdexHeader.getDexChecksums().length; ++i) {
                if (this.vdexHeader.getDexChecksums()[i] != checksum) continue;
                if (this.vdexHeader.getDexHeaderList().size() > i) {
                    return this.vdexHeader.getDexHeaderList().get(i);
                }
                return this.dexHeadersMap.get(i);
            }
        }
        return null;
    }

    @Override
    public ArtHeader getArtHeader() {
        return this.artHeader;
    }

    @Override
    public OatHeader getOatHeader() {
        return this.oatHeader;
    }

    @Override
    public List<DexHeader> getDexHeaders() {
        return this.dexHeaders;
    }

    @Override
    public VdexHeader getVdexHeader() {
        return this.vdexHeader;
    }

    private void loadVdexHeader(Program oatProgram, TaskMonitor monitor, MessageLog log) {
        monitor.setMessage("Loading VDEX headers...");
        String baseName = FilenameUtils.removeExtension((String)oatProgram.getName());
        String vdexProgramName = baseName + ".vdex";
        DomainFile domainFile = oatProgram.getDomainFile();
        DomainFolder parentFolder = domainFile.getParent();
        if (this.lookInProjectFolder(OatBundle.HeaderType.VDEX, parentFolder, vdexProgramName, monitor, log)) {
            return;
        }
        if (this.lookInProjectFolder(OatBundle.HeaderType.VDEX, parentFolder.getParent(), vdexProgramName, monitor, log)) {
            return;
        }
    }

    private void loadDexHeaders(Program oatProgram, TaskMonitor monitor, MessageLog log) {
        DomainFolder appVdexFolder;
        DomainFolder apkOrJarFolder;
        monitor.setMessage("Loading DEX headers...");
        DomainFolder odexApkFolder = this.getOdexApkOrJarFolder();
        if (odexApkFolder != null) {
            for (DomainFile file : odexApkFolder.getFiles()) {
                if (monitor.isCancelled()) break;
                if (!file.getName().startsWith("classes") || !file.getName().endsWith(".dex")) continue;
                this.lookInProjectFolder(OatBundle.HeaderType.DEX, odexApkFolder, file.getName(), monitor, log);
            }
        }
        if ((apkOrJarFolder = this.getApkOrJarFolder()) != null) {
            for (DomainFile file : apkOrJarFolder.getFiles()) {
                if (monitor.isCancelled()) break;
                if (!file.getName().startsWith("classes") || !file.getName().endsWith(".dex")) continue;
                this.lookInProjectFolder(OatBundle.HeaderType.DEX, apkOrJarFolder, file.getName(), monitor, log);
            }
        }
        if ((appVdexFolder = this.getAppVdexFolder()) != null) {
            for (DomainFile file : appVdexFolder.getFiles()) {
                if (monitor.isCancelled()) break;
                if (!file.getName().startsWith("cdex")) continue;
                this.lookInProjectFolder(OatBundle.HeaderType.CDEX, appVdexFolder, file.getName(), monitor, log);
            }
        }
    }

    private void loadArtHeader(Program oatProgram, TaskMonitor monitor, MessageLog log) {
        monitor.setMessage("Loading ART headers...");
        String baseName = FilenameUtils.removeExtension((String)oatProgram.getName());
        String artProgramName = baseName + ".art";
        DomainFile domainFile = oatProgram.getDomainFile();
        DomainFolder parentFolder = domainFile.getParent();
        if (this.lookInProjectFolder(OatBundle.HeaderType.ART, parentFolder, artProgramName, monitor, log)) {
            return;
        }
        if (this.lookInProjectFolder(OatBundle.HeaderType.ART, parentFolder.getParent(), artProgramName, monitor, log)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lookInProjectFolder(OatBundle.HeaderType type, DomainFolder parentFolder, String programName, TaskMonitor monitor, MessageLog log) {
        DomainFile child = parentFolder.getFile(programName);
        if (child != null) {
            Program program = null;
            try {
                program = (Program)child.getDomainObject((Object)this, true, true, monitor);
                MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
                boolean bl = this.makeHeader(type, programName, (ByteProvider)provider, monitor);
                return bl;
            }
            catch (Exception e) {
                log.appendMsg("Unable to locate matching: " + type);
            }
            finally {
                if (program != null) {
                    program.release((Object)this);
                }
            }
        }
        return false;
    }

    private int getDexIndex(String dexName) {
        try {
            if (dexName.startsWith("classes") && dexName.endsWith(".dex")) {
                String indexString = dexName.substring("classes".length(), dexName.length() - ".dex".length());
                if (indexString.length() == 0) {
                    return 0;
                }
                return Integer.parseInt(indexString) - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private DomainFolder getApkOrJarFolder() {
        String baseName = FilenameUtils.removeExtension((String)this.oatProgram.getName());
        DomainFile domainFile = this.oatProgram.getDomainFile();
        String pathName = domainFile.getPathname();
        if (pathName.matches(".*/[^/]*/[^/]*")) {
            DomainFolder parentFolder = domainFile.getParent();
            parentFolder = parentFolder.getParent();
            if ((parentFolder = parentFolder.getParent()).getFolder(baseName + ".apk") != null) {
                return parentFolder.getFolder(baseName + ".apk");
            }
            if (parentFolder.getFolder(baseName + ".jar") != null) {
                return parentFolder.getFolder(baseName + ".jar");
            }
        }
        return null;
    }

    private DomainFolder getAppVdexFolder() {
        String baseName = FilenameUtils.removeExtension((String)this.oatProgram.getName());
        DomainFile domainFile = this.oatProgram.getDomainFile();
        DomainFolder parentFolder = domainFile.getParent();
        return parentFolder.getFolder(baseName + ".vdex");
    }

    private DomainFolder getOdexApkOrJarFolder() {
        String baseName = FilenameUtils.removeExtension((String)this.oatProgram.getName());
        DomainFile domainFile = this.oatProgram.getDomainFile();
        DomainFolder parentFolder = domainFile.getParent();
        if ((parentFolder = parentFolder.getFolder(baseName + ".odex")) != null) {
            if (parentFolder.getFolder(baseName + ".apk") != null) {
                return parentFolder.getFolder(baseName + ".apk");
            }
            if (parentFolder.getFolder(baseName + ".jar") != null) {
                return parentFolder.getFolder(baseName + ".jar");
            }
        }
        return null;
    }

    private boolean makeHeader(OatBundle.HeaderType type, String programName, ByteProvider provider, TaskMonitor monitor) throws IOException, UnsupportedVdexVersionException, CancelledException, UnsupportedArtVersionException {
        BinaryReader reader = new BinaryReader(provider, this.isLittleEndian);
        switch (type) {
            case ART: {
                ArtHeader artHeader;
                this.artHeader = artHeader = ArtFactory.newArtHeader(reader);
                return true;
            }
            case CDEX: 
            case DEX: {
                DexHeader dexHeader = DexHeaderFactory.getDexHeader(reader, true);
                this.dexHeaders.add(dexHeader);
                this.dexHeadersMap.put(this.getDexIndex(programName), dexHeader);
                return true;
            }
            case VDEX: {
                VdexHeader vdexHeader = VdexFactory.getVdexHeader(reader);
                vdexHeader.parse(reader, monitor);
                this.vdexHeader = vdexHeader;
                return true;
            }
        }
        return false;
    }
}

