/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.analyzer.DexHeaderFormatMarkup;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.task.TaskMonitor;

public class DexHeaderFormatAnalyzer
extends FileFormatAnalyzer {
    private static final String CREATE_FRAGMENTS_OPTION_NAME = "Create Fragments";
    private static final boolean CREATE_FRAGMENTS_DEFAULT = true;
    private boolean isCreateFragments = true;

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address baseAddress = this.toAddr(program, 0L);
        if (this.getDataAt(program, baseAddress) != null) {
            log.appendMsg("data already exists.");
            return true;
        }
        DexHeaderFormatMarkup markup = new DexHeaderFormatMarkup(this, program, baseAddress);
        markup.markup(monitor, log);
        return true;
    }

    boolean isCreateFragments() {
        return this.isCreateFragments;
    }

    @Override
    public void removeEmptyFragments(Program program) throws NotEmptyException {
        super.removeEmptyFragments(program);
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android Dalvik EXecutable (DEX) / Compact DEX (CDEX) Header Format";
    }

    public String getName() {
        return "Android DEX/CDEX Header Format";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(0);
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        super.registerOptions(options, program);
        options.registerOption(CREATE_FRAGMENTS_OPTION_NAME, (Object)true, null, "If selected, then create Program Tree fragments for each DEX element. Disable to speed up analysis.");
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        this.isCreateFragments = options.getBoolean(CREATE_FRAGMENTS_OPTION_NAME, true);
    }
}

