/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.main.EditPluginPathDialog;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.File;
import java.io.IOException;

class EditActionManager {
    private FrontEndPlugin plugin;
    private FrontEndTool tool;
    private DockingAction editPluginPathAction;
    private DockingAction editCertPathAction;
    private DockingAction clearCertPathAction;
    private EditPluginPathDialog pluginPathDialog;
    private GhidraFileChooser certFileChooser;

    EditActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = (FrontEndTool)plugin.getTool();
        this.createActions();
    }

    private void createActions() {
        this.editPluginPathAction = new DockingAction("Edit Plugin Path", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.editPluginPath();
            }
        };
        this.editPluginPathAction.setEnabled(true);
        this.editPluginPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Plugin Path..."}, "GEdit"));
        this.editCertPathAction = new DockingAction("Set PKI Certificate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.editCertPath();
            }
        };
        this.editCertPathAction.setEnabled(true);
        this.editCertPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Set PKI Certificate..."}, "PKI"));
        this.clearCertPathAction = new DockingAction("Clear PKI Certificate", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                EditActionManager.this.clearCertPath();
            }
        };
        this.clearCertPathAction.setEnabled(ApplicationKeyManagerFactory.getKeyStore() != null);
        this.clearCertPathAction.setMenuBarData(new MenuData(new String[]{"&Edit", "Clear PKI Certificate..."}, "PKI"));
        this.clearCertPathAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Set_PKI_Certificate"));
        this.tool.addAction((DockingActionIf)this.editCertPathAction);
        this.tool.addAction((DockingActionIf)this.clearCertPathAction);
        this.tool.addAction((DockingActionIf)this.editPluginPathAction);
    }

    private void editPluginPath() {
        if (this.pluginPathDialog == null) {
            this.pluginPathDialog = new EditPluginPathDialog();
        }
        this.pluginPathDialog.show(this.tool);
    }

    private void clearCertPath() {
        String path = ApplicationKeyManagerFactory.getKeyStore();
        if (path == null) {
            this.clearCertPathAction.setEnabled(false);
            return;
        }
        if (1 != OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"Clear PKI Certificate", (String)("Clear PKI certificate setting?\n(" + path + ")"))) {
            return;
        }
        try {
            ApplicationKeyManagerFactory.setKeyStore(null, (boolean)true);
            this.clearCertPathAction.setEnabled(false);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Error occurred while clearing PKI certificate setting: " + e.getMessage()));
        }
    }

    private void editCertPath() {
        if (this.certFileChooser == null) {
            this.certFileChooser = this.createCertFileChooser();
        }
        File dir = null;
        File oldFile = null;
        String path = ApplicationKeyManagerFactory.getKeyStore();
        if (path != null) {
            oldFile = new File(path);
            dir = oldFile.getParentFile();
            if (!oldFile.isFile()) {
                oldFile = null;
                if (!dir.isDirectory()) {
                    dir = null;
                }
            }
        }
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        if (oldFile != null) {
            this.certFileChooser.setSelectedFile(oldFile);
        } else {
            this.certFileChooser.setCurrentDirectory(dir);
        }
        boolean validInput = false;
        while (!validInput) {
            File file = this.certFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                ApplicationKeyManagerFactory.setKeyStore((String)file.getAbsolutePath(), (boolean)true);
                this.clearCertPathAction.setEnabled(true);
                validInput = true;
            }
            catch (IOException e) {
                Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Certificate Failure", (Object)("Failed to initialize key manager.\n" + e.getMessage()), (Throwable)e);
                file = null;
            }
        }
    }

    private GhidraFileChooser createCertFileChooser() {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
        fileChooser.setTitle("Select Certificate (req'd for PKI authentication only)");
        fileChooser.setApproveButtonText("Set Certificate");
        fileChooser.setFileFilter(ApplicationKeyManagerFactory.CERTIFICATE_FILE_FILTER);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setHelpLocation(new HelpLocation(this.plugin.getName(), "Set_PKI_Certificate"));
        return fileChooser;
    }
}

