/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.util.pcodeInject.JavaComputationalCategory;
import ghidra.javaclass.format.ClassFileAnalysisState;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class InjectPayloadJavaParameters
implements InjectPayload {
    private String name;
    private String sourceName;
    private InjectPayload.InjectParameter[] noParams;
    private boolean analysisStateRecoverable;
    private AddressSpace constantSpace;
    private int paramSpaceID;
    private int lvaID;
    private Varnode temp4;
    private Varnode temp8;
    private Varnode zero;
    private Varnode four;
    private Varnode eight;
    private Varnode LVA;

    public InjectPayloadJavaParameters(String nm, String srcName, SleighLanguage language, long uniqBase) {
        this.name = nm;
        this.sourceName = srcName;
        this.noParams = new InjectPayload.InjectParameter[0];
        this.analysisStateRecoverable = true;
        this.constantSpace = language.getAddressFactory().getConstantSpace();
        AddressSpace uniqueSpace = language.getAddressFactory().getUniqueSpace();
        Address temp4Address = uniqueSpace.getAddress(uniqBase);
        Address temp8Address = uniqueSpace.getAddress(uniqBase + 16L);
        AddressSpace paramSpace = language.getAddressFactory().getAddressSpace("parameterSpace");
        this.paramSpaceID = paramSpace.getSpaceID();
        AddressSpace lva = language.getAddressFactory().getAddressSpace("localVariableArray");
        this.lvaID = lva.getSpaceID();
        this.temp4 = new Varnode(temp4Address, 4);
        this.temp8 = new Varnode(temp8Address, 8);
        this.zero = new Varnode(this.constantSpace.getAddress(0L), 4);
        this.four = new Varnode(this.constantSpace.getAddress(4L), 4);
        this.eight = new Varnode(this.constantSpace.getAddress(8L), 4);
        Address LVAregAddress = language.getRegister("LVA").getAddress();
        this.LVA = new Varnode(LVAregAddress, 4);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return 3;
    }

    public String getSource() {
        return this.sourceName;
    }

    public int getParamShift() {
        return 0;
    }

    public InjectPayload.InjectParameter[] getInput() {
        return this.noParams;
    }

    public InjectPayload.InjectParameter[] getOutput() {
        return this.noParams;
    }

    public boolean isErrorPlaceholder() {
        return false;
    }

    public void inject(InjectContext context, PcodeEmit emit) {
    }

    public PcodeOp[] getPcode(Program program, InjectContext con) {
        ClassFileAnalysisState analysisState;
        if (!this.analysisStateRecoverable) {
            return new PcodeOp[0];
        }
        try {
            analysisState = ClassFileAnalysisState.getState(program);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage(), (Throwable)e);
            this.analysisStateRecoverable = false;
            return new PcodeOp[0];
        }
        ClassFileJava classFile = analysisState.getClassFile();
        MethodInfoJava methodInfo = analysisState.getMethodInfo(con.baseAddr);
        if (methodInfo == null) {
            return new PcodeOp[0];
        }
        int descriptorIndex = methodInfo.getDescriptorIndex();
        ConstantPoolUtf8Info descriptorInfo = (ConstantPoolUtf8Info)classFile.getConstantPool()[descriptorIndex];
        String descriptor = descriptorInfo.getString();
        ArrayList<JavaComputationalCategory> paramCategories = new ArrayList<JavaComputationalCategory>();
        if (!methodInfo.isStatic()) {
            paramCategories.add(JavaComputationalCategory.CAT_1);
        }
        paramCategories.addAll(DescriptorDecoder.getParameterCategories(descriptor));
        int numOps = paramCategories.size();
        if (paramCategories.size() == 0) {
            return new PcodeOp[0];
        }
        PcodeOp[] resOps = new PcodeOp[1 + 3 * numOps];
        int seqNum = 0;
        PcodeOp copy = new PcodeOp(con.baseAddr, seqNum, 1);
        copy.setInput(this.zero, 0);
        copy.setOutput(this.LVA);
        resOps[seqNum++] = copy;
        Varnode tempLocation = null;
        Varnode increment = null;
        for (JavaComputationalCategory cat : paramCategories) {
            if (cat.equals((Object)JavaComputationalCategory.CAT_1)) {
                tempLocation = this.temp4;
                increment = this.four;
            } else {
                tempLocation = this.temp8;
                increment = this.eight;
            }
            PcodeOp load = new PcodeOp(con.baseAddr, seqNum, 2);
            load.setInput(new Varnode(this.constantSpace.getAddress((long)this.paramSpaceID), 4), 0);
            load.setInput(this.LVA, 1);
            load.setOutput(tempLocation);
            resOps[seqNum++] = load;
            PcodeOp store = new PcodeOp(con.baseAddr, seqNum, 3);
            store.setInput(new Varnode(this.constantSpace.getAddress((long)this.lvaID), 4), 0);
            store.setInput(this.LVA, 1);
            store.setInput(tempLocation, 2);
            resOps[seqNum++] = store;
            PcodeOp add = new PcodeOp(con.baseAddr, seqNum, 19);
            add.setInput(this.LVA, 0);
            add.setInput(increment, 1);
            add.setOutput(this.LVA);
            resOps[seqNum++] = add;
        }
        return resOps;
    }

    public boolean isFallThru() {
        return true;
    }

    public boolean isIncidentalCopy() {
        return false;
    }

    public void saveXml(StringBuilder buffer) {
        buffer.append("<pcode");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"inject", (String)"uponentry");
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buffer, (String)"dynamic", (boolean)true);
        buffer.append("/>\n");
    }

    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement el = parser.start(new String[0]);
        String injectString = el.getAttribute("inject");
        if (injectString == null || !injectString.equals("uponentry")) {
            throw new XmlParseException("Expecting inject=\"uponentry\" attribute");
        }
        boolean isDynamic = SpecXmlUtils.decodeBoolean((String)el.getAttribute("dynamic"));
        if (!isDynamic) {
            throw new XmlParseException("Expecting dynamic attribute");
        }
        parser.end(el);
    }

    public boolean equals(Object obj) {
        return obj instanceof InjectPayloadJavaParameters;
    }

    public int hashCode() {
        return 123474217;
    }
}

