/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.Trimmer;

public class HeadCropTrimmer
implements Trimmer {
    private int firstBases;
    private int midBases;
    private int lastBases;
    private int firstMaxLength = 0x3FFFFFFF;
    private int midMaxLength = 0x3FFFFFFF;
    private int lastMaxLength = 0x3FFFFFFF;

    public HeadCropTrimmer(String args) {
        String[] arg = args.split(":");
        switch (arg.length) {
            case 1: {
                this.midBases = this.lastBases = Integer.parseInt(arg[0]);
                this.firstBases = this.lastBases;
                break;
            }
            case 2: {
                this.midBases = this.lastBases = Integer.parseInt(arg[0]);
                this.firstBases = this.lastBases;
                this.midMaxLength = this.lastMaxLength = Integer.parseInt(arg[1]);
                this.firstMaxLength = this.lastMaxLength;
                break;
            }
            case 4: {
                this.firstBases = this.midBases = Integer.parseInt(arg[0]);
                this.firstMaxLength = this.midMaxLength = Integer.parseInt(arg[1]);
                this.lastBases = Integer.parseInt(arg[2]);
                this.lastMaxLength = Integer.parseInt(arg[3]);
                break;
            }
            case 6: {
                this.firstBases = Integer.parseInt(arg[0]);
                this.firstMaxLength = Integer.parseInt(arg[1]);
                this.midBases = Integer.parseInt(arg[2]);
                this.midMaxLength = Integer.parseInt(arg[3]);
                this.lastBases = Integer.parseInt(arg[4]);
                this.lastMaxLength = Integer.parseInt(arg[5]);
                break;
            }
        }
    }

    public FastqRecord[] processRecords(FastqRecord[] in) {
        if (in == null) {
            return null;
        }
        FastqRecord[] out = new FastqRecord[in.length];
        int lastRecord = in.length - 1;
        if (in.length > 0 && in[0] != null) {
            out[0] = this.processRecord(in[0], this.firstBases, this.firstMaxLength);
        }
        for (int i = 1; i < lastRecord; ++i) {
            if (in[i] == null) continue;
            out[i] = this.processRecord(in[i], this.midBases, this.midMaxLength);
        }
        if (lastRecord > 0 && in[lastRecord] != null) {
            out[lastRecord] = this.processRecord(in[lastRecord], this.lastBases, this.lastMaxLength);
        }
        return out;
    }

    private FastqRecord processRecord(FastqRecord in, int bases, int maxLength) {
        int toTrim;
        int len = in.getSequence().length();
        int overLen = len - (toTrim = bases) - maxLength;
        if (overLen > 0) {
            toTrim += overLen;
        }
        if (len <= toTrim) {
            return null;
        }
        if (toTrim == 0) {
            return in;
        }
        return new FastqRecord(in, toTrim, len - toTrim);
    }
}

