/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.LinkedList;
import java.util.Random;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.LossOfFunction;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationLof
extends TestCasesIntegrationBase {
    public static final int NUM_DEL_TEST = 10;
    Config config;
    Random random = new Random(20121030L);

    @After
    public void after() {
        this.config = null;
    }

    @Override
    Marker cdsMarker(Transcript tr) {
        int start = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int end = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        return new Marker(tr.getParent(), start, end, false, "");
    }

    void checkLof(Transcript tr) {
        if (!tr.isProteinCoding()) {
            return;
        }
        this.checkLofSplice(tr);
        this.checkLofStartLost(tr);
        this.checkLofExonDeleted(tr);
        this.checkLofFrameShift(tr);
    }

    void checkLofExonDeleted(Transcript tr) {
        this.checkLofExonDeletedFirstExon(tr);
        this.checkLofExonDeletedHalf(tr);
    }

    void checkLofExonDeletedFirstExon(Transcript tr) {
        Exon ex = tr.getFirstCodingExon();
        Variant Variant2 = new Variant((Marker)tr.getChromosome(), ex.getStart(), "AC", "A");
        Variant2.setStart(ex.getStart());
        Variant2.setEnd(ex.getEnd());
        Variant2.setVariantType(Variant.VariantType.DEL);
        if (this.verbose) {
            Gpr.debug("Variant:" + Variant2);
        }
        LinkedList<VariantEffect> changeEffects = this.variantEffects(Variant2, EffectType.EXON_DELETED, ex);
        LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals(true, islof);
    }

    void checkLofExonDeletedHalf(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        for (int i = 0; i < 10; ++i) {
            int delStart = this.random.nextInt(tr.size() - 1) + tr.getStart();
            int delEnd = this.random.nextInt(tr.getEnd() - delStart) + delStart + 1;
            Variant Variant2 = new Variant((Marker)tr.getChromosome(), delStart, "AC", "A");
            Variant2.setStart(delStart);
            Variant2.setEnd(delEnd);
            if (this.verbose) {
                Gpr.debug("Variant:" + Variant2);
            }
            Variant2.setVariantType(Variant.VariantType.DEL);
            Marker codingDel = cds.intersect(Variant2);
            if (codingDel == null) continue;
            int numBases = 0;
            for (Exon ex : tr) {
                numBases += codingDel.intersectSize(ex);
            }
            double perc = (double)numBases / (double)tr.cds().length();
            boolean delIsLof = perc > 0.5;
            LinkedList<VariantEffect> changeEffects = this.variantEffects(Variant2, EffectType.TRANSCRIPT, tr);
            LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
            boolean islof = lof.isLof();
            Assert.assertEquals(delIsLof, islof);
        }
    }

    void checkLofFrameShift(Transcript tr) {
        Marker cds = this.cdsMarker(tr);
        int codingBase = 0;
        for (Exon ex : tr.sortedStrand()) {
            int start = tr.isStrandPlus() ? ex.getStart() : ex.getEnd();
            int step2 = tr.isStrandPlus() ? 1 : -1;
            int pos = start;
            while (ex.intersects(pos)) {
                boolean ins = this.random.nextBoolean();
                Variant Variant2 = ins ? new Variant((Marker)tr.getChromosome(), pos, "A", "AC") : new Variant((Marker)tr.getChromosome(), pos, "AC", "A");
                Variant2.setVariantType(ins ? Variant.VariantType.INS : Variant.VariantType.DEL);
                if (this.verbose) {
                    Gpr.debug("Variant:" + Variant2);
                }
                LinkedList<VariantEffect> changeEffects = this.variantEffects(Variant2, EffectType.FRAME_SHIFT, ex);
                VariantEffect changeEffect = changeEffects.get(0);
                changeEffect.setCodons("", "", codingBase / 3, codingBase % 3);
                int aaLen = changeEffect.getAaLength();
                boolean isFsLof = false;
                if (cds.intersects(pos)) {
                    double perc = (double)(codingBase / 3) / (double)aaLen;
                    isFsLof = 0.05 <= perc && perc <= 0.95;
                    ++codingBase;
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(isFsLof, islof);
                pos += step2;
            }
        }
    }

    void checkLofSplice(Transcript tr) {
        for (Intron intron : tr.introns()) {
            this.checkSpliceDonor(tr, intron);
            this.checkSpliceAcceptor(tr, intron);
        }
    }

    void checkLofStartLost(Transcript tr) {
        int pos = tr.getCdsStart();
        Variant Variant2 = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
        if (this.verbose) {
            Gpr.debug("Variant:" + Variant2);
        }
        Exon exon = null;
        for (Exon ex : tr) {
            if (!ex.intersects(pos)) continue;
            exon = ex;
        }
        if (exon == null) {
            throw new RuntimeException("Cannot find first exon for transcript " + tr.getId());
        }
        LinkedList<VariantEffect> changeEffects = this.variantEffects(Variant2, EffectType.START_LOST, exon);
        LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
        boolean islof = lof.isLof();
        Assert.assertEquals(true, islof);
    }

    void checkSpliceAcceptor(Transcript tr, Intron intron) {
        int step2;
        int n = step2 = tr.isStrandPlus() ? 1 : -1;
        if (intron.getRank() > 1) {
            int posDonor = tr.isStrandPlus() ? intron.getEnd() : intron.getStart();
            int maxSize = Math.min(intron.size(), 2);
            posDonor -= step2 * (maxSize - 1);
            if (this.verbose) {
                Gpr.debug("Intron size: " + intron.size());
            }
            if (maxSize <= 0) {
                throw new RuntimeException("Max splice size is " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                Variant Variant2 = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
                Marker marker = this.findMarker(this.config.getSnpEffectPredictor(), Variant2, EffectType.SPLICE_SITE_ACCEPTOR, null, intron);
                LinkedList<VariantEffect> changeEffects = this.variantEffects(Variant2, EffectType.SPLICE_SITE_ACCEPTOR, marker);
                if (this.verbose) {
                    Gpr.debug("Variant:" + Variant2);
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(true, islof);
                ++i;
                pos += step2;
            }
        }
    }

    void checkSpliceDonor(Transcript tr, Intron intron) {
        int step2 = tr.isStrandPlus() ? 1 : -1;
        int maxRank = tr.numChilds();
        if (intron.getRank() < maxRank) {
            int posDonor = tr.isStrandPlus() ? intron.getStart() : intron.getEnd();
            int maxSize = Math.min(intron.size(), 2);
            if (this.verbose) {
                Gpr.debug("Intron size: " + intron.size() + "\tmaxSize: " + maxSize);
            }
            if (maxSize <= 0) {
                throw new RuntimeException("Max splice size is non-positive: " + maxSize);
            }
            int pos = posDonor;
            int i = 0;
            while (i < maxSize) {
                if (this.verbose) {
                    Gpr.debug("Position: " + tr.getChromosome().getId() + ":" + posDonor);
                }
                Variant variant = new Variant((Marker)tr.getChromosome(), pos, "A", "C");
                Marker marker = this.findMarker(this.config.getSnpEffectPredictor(), variant, EffectType.SPLICE_SITE_DONOR, null, intron);
                LinkedList<VariantEffect> changeEffects = this.variantEffects(variant, EffectType.SPLICE_SITE_DONOR, marker);
                if (this.verbose) {
                    Gpr.debug("Variant:" + variant);
                }
                LossOfFunction lof = new LossOfFunction(this.config, changeEffects);
                boolean islof = lof.isLof();
                Assert.assertEquals(true, islof);
                ++i;
                pos += step2;
            }
        }
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeVer = "testHg3766Chr1";
        this.config = new Config(genomeVer, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        this.config.setTreatAllAsProteinCoding(true);
        this.config.getSnpEffectPredictor().buildForest();
        int i = 1;
        for (Gene gene : this.config.getGenome().getGenes()) {
            Gpr.showMark(i++, 10);
            for (Transcript tr : gene) {
                if (this.verbose) {
                    System.err.println(tr);
                }
                this.checkLof(tr);
            }
        }
    }

    @Test
    public void test_02() {
        String[] args = new String[]{"testHg3775Chr22", "-noLog", "-i", "bed", "tests/test_lof_02.bed"};
        SnpEff snpeff = new SnpEff(args);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        boolean ok = snpeff.run();
        Assert.assertEquals(true, ok);
    }

    @Override
    LinkedList<VariantEffect> variantEffects(Variant variant, EffectType effectType, Marker marker) {
        VariantEffect changeEffect = new VariantEffect(variant);
        changeEffect.set(marker, effectType, effectType.effectImpact(), "");
        LinkedList<VariantEffect> changeEffects = new LinkedList<VariantEffect>();
        changeEffects.add(changeEffect);
        return changeEffects;
    }
}

