/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import java.util.Collections;
import java.util.LinkedList;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqTools;
import org.snpeff.fastq.FastqTrimmerMedian;

public class FastqTrimmerAdrian
extends FastqTrimmerMedian {
    public FastqTrimmerAdrian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases, runningMedianLength);
        this.minBases = minBases;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int i;
        int[] qual = FastqTools.qualtityArray(fastq);
        for (i = 0; i < qual.length - this.runningMedianLength; i += 2) {
            LinkedList<Integer> list2 = new LinkedList<Integer>();
            for (int k = 1; k <= this.runningMedianLength; ++k) {
                list2.add(qual[i + k]);
            }
            Collections.sort(list2);
            int size2 = list2.size();
            int med = 0;
            med = list2.size() % 2 == 1 ? (Integer)list2.get(size2 / 2) : ((Integer)list2.get(size2 / 2 - 1) + (Integer)list2.get(size2 / 2)) / 2;
            if (med < this.qualityThreshold) break;
        }
        if ((i -= this.runningMedianLength - 1) > this.minBases) {
            return i;
        }
        return 0;
    }
}

