/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io.mmcif;

import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.io.mmcif.ChemCompProvider;
import org.biojava.bio.structure.io.mmcif.DownloadChemCompProvider;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava3.core.util.SoftHashMap;

public class ChemCompGroupFactory {
    static ChemCompProvider chemCompProvider = new DownloadChemCompProvider();
    static SoftHashMap<String, ChemComp> cache = new SoftHashMap(0);

    public static ChemComp getChemComp(String recordName) {
        ChemComp cc = cache.get(recordName = recordName.toUpperCase().trim());
        if (cc != null) {
            return cc;
        }
        cc = chemCompProvider.getChemComp(recordName);
        cache.put(recordName, cc);
        return cc;
    }

    public static void setChemCompProvider(ChemCompProvider provider) {
        chemCompProvider = provider;
    }

    public static ChemCompProvider getChemCompProvider() {
        return chemCompProvider;
    }

    public static Group getGroupFromChemCompDictionary(String recordName) {
        recordName = recordName.toUpperCase().trim();
        HetatomImpl g = null;
        try {
            ChemComp cc = ChemCompGroupFactory.getChemComp(recordName);
            if (cc == null) {
                return null;
            }
            if (PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType())) {
                String parent;
                AminoAcidImpl aa = new AminoAcidImpl();
                String one_letter = cc.getOne_letter_code();
                if ((one_letter == null || one_letter.equals("X") || one_letter.equals("?") || one_letter.length() == 0) && (parent = cc.getMon_nstd_parent_comp_id()) != null && parent.length() == 3) {
                    String parentid = cc.getMon_nstd_parent_comp_id();
                    ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentid);
                    one_letter = parentCC.getOne_letter_code();
                }
                if (one_letter == null || one_letter.length() == 0 || one_letter.equals("?")) {
                    System.err.println(" Problem with chemical component: " + recordName + "  Did not find one letter code!");
                    aa.setAminoType(Character.valueOf('X'));
                } else {
                    aa.setAminoType(Character.valueOf(one_letter.charAt(0)));
                }
                g = aa;
            } else if (PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) {
                NucleotideImpl nuc = new NucleotideImpl();
                g = nuc;
            } else {
                g = new HetatomImpl();
            }
            g.setChemComp(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return g;
    }

    public static String getOneLetterCode(ChemComp cc) {
        String oneLetter = cc.getOne_letter_code();
        if (oneLetter == null || oneLetter.equals("X") || oneLetter.equals("?")) {
            String parentId = cc.getMon_nstd_parent_comp_id();
            if (parentId == null) {
                return oneLetter;
            }
            ChemComp parentCC = ChemCompGroupFactory.getChemComp(parentId);
            if (parentCC == null) {
                return oneLetter;
            }
            oneLetter = parentCC.getOne_letter_code();
        }
        return oneLetter;
    }
}

