/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

public enum BioType {
    prime3_overlapping_ncrna,
    antisense,
    IG_C_gene,
    IG_C_pseudogene,
    IG_D_gene,
    IG_J_gene,
    IG_J_pseudogene,
    IG_V_gene,
    IG_V_pseudogene,
    lincRNA,
    macro_lncRNA,
    miRNA,
    misc_RNA,
    Mt_rRNA,
    Mt_tRNA,
    nonsense_mediated_decay,
    non_stop_decay,
    polymorphic_pseudogene,
    processed_pseudogene,
    processed_transcript,
    protein_coding,
    pseudogene,
    retained_intron,
    ribozyme,
    rRNA,
    scaRNA,
    sense_intronic,
    sense_overlapping,
    snoRNA,
    snRNA,
    sRNA,
    TEC,
    transcribed_processed_pseudogene,
    transcribed_unitary_pseudogene,
    transcribed_unprocessed_pseudogene,
    translated_unprocessed_pseudogene,
    TR_C_gene,
    TR_D_gene,
    TR_J_gene,
    TR_J_pseudogene,
    TR_V_gene,
    TR_V_pseudogene,
    unitary_pseudogene,
    unprocessed_pseudogene,
    vaultRNA;


    public static BioType coding(boolean isCoding) {
        return isCoding ? protein_coding : pseudogene;
    }

    public static BioType parse(String str) {
        try {
            if (str == null) {
                return null;
            }
            return BioType.valueOf(str);
        }
        catch (Exception e) {
            if (str != null) {
                switch (str.toLowerCase()) {
                    case "mrna": 
                    case "protein": 
                    case "cds": 
                    case "trna": 
                    case "start_codon": 
                    case "stop_codon": 
                    case "five_prime_utr": 
                    case "5'-utr": 
                    case "5'utr": 
                    case "5utr": 
                    case "three_prime_utr": 
                    case "3'-utr": 
                    case "3'utr": 
                    case "3utr": {
                        return protein_coding;
                    }
                    case "pseudogenic_transcript": 
                    case "pseudogenic_exon": {
                        return transcribed_processed_pseudogene;
                    }
                    case "ncrna": {
                        return lincRNA;
                    }
                    case "rrna": {
                        return rRNA;
                    }
                    case "mirna": {
                        return miRNA;
                    }
                    case "snrna": {
                        return snRNA;
                    }
                    case "snorna": {
                        return snoRNA;
                    }
                    case "3prime_overlapping_ncrna": {
                        return prime3_overlapping_ncrna;
                    }
                }
                return null;
            }
            return null;
        }
    }

    public boolean isProteinCoding() {
        return this == protein_coding || this == IG_C_gene || this == IG_D_gene || this == IG_J_gene || this == IG_V_gene || this == nonsense_mediated_decay || this == non_stop_decay || this == polymorphic_pseudogene || this == TR_C_gene || this == TR_D_gene || this == TR_J_gene || this == TR_V_gene;
    }
}

