/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.TranscriptSequence;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.CompoundSet;

public class CDSSequence
extends DNASequence {
    Integer phase = 0;
    TranscriptSequence parentTranscriptSequence;

    public CDSSequence(TranscriptSequence parentSequence, int bioBegin, int bioEnd, int phase) {
        this.parentTranscriptSequence = parentSequence;
        this.setParentSequence(this.parentTranscriptSequence);
        this.setBioBegin(bioBegin);
        this.setBioEnd(bioEnd);
        this.phase = phase;
    }

    @Override
    public int getLength() {
        return Math.abs(this.getBioEnd() - this.getBioBegin()) + 1;
    }

    public Integer getPhase() {
        return this.phase;
    }

    public Strand getStrand() {
        return this.parentTranscriptSequence.getStrand();
    }

    public String getCodingSequence() {
        String sequence2 = this.getSequenceAsString(this.getBioBegin(), this.getBioEnd(), this.getStrand());
        if (this.getStrand() == Strand.NEGATIVE) {
            StringBuilder b = new StringBuilder(this.getLength());
            CompoundSet compoundSet = this.getCompoundSet();
            for (int i = 0; i < sequence2.length(); ++i) {
                String nucleotide = sequence2.charAt(i) + "";
                NucleotideCompound nucleotideCompound = (NucleotideCompound)compoundSet.getCompoundForString(nucleotide);
                b.append(nucleotideCompound.getComplement().getShortName());
            }
            sequence2 = b.toString();
        }
        return sequence2;
    }
}

