/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class weibull {
    public static double density(double x2, double shape, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x2 + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 0.0;
        }
        double tmp1 = Math.pow(x2 / scale, shape - 1.0);
        double tmp2 = tmp1 * (x2 / scale);
        return shape * tmp1 * Math.exp(-tmp2) / scale;
    }

    public static double cumulative(double x2, double shape, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x2 + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.pow(x2 / scale, shape));
    }

    public static double quantile(double x2, double shape, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x2 + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0 || x2 < 0.0 || x2 > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return scale * Math.pow(-Math.log(1.0 - x2), 1.0 / shape);
    }

    public static double random(double shape, double scale, uniform PRNG) {
        if (Double.isInfinite(shape) || Double.isInfinite(scale) || shape <= 0.0 || scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return scale * Math.pow(-Math.log(uniform.random()), 1.0 / shape);
    }
}

