/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

public class misc {
    static final double MAXPLACES = 15.0;
    static final double BIGGEST = 4.503599627370496E15;
    static final double[] gamcs = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19, -1.027378057872228E-19, 1.7627028160605298E-20, -3.024320653735306E-21, 5.188914660218398E-22, -8.902770842456576E-23, 1.5274740684933426E-23, -2.620731256187363E-24, 4.496464047830539E-25, -7.714712731336878E-26, 1.323635453126044E-26, -2.2709994129429287E-27, 3.8964189980039913E-28, -6.685198115125953E-29, 1.1469986631400244E-29, -1.9679385863451348E-30, 3.376448816585338E-31, -5.793070335782136E-32};
    static int signgam;
    static double m_zero;
    static double m_one;
    static double m_tiny;

    static {
        m_zero = 0.0;
        m_one = 1.0;
        m_tiny = Double.MIN_VALUE;
    }

    public static double beta(double a, double b) {
        double xmax = 0.0;
        double alnsml = 0.0;
        double val = 0.0;
        double xmin = 0.0;
        if (xmax == 0.0) {
            double[] temp = misc.gammalims(xmin, xmax);
            xmin = temp[0];
            xmax = temp[1];
            alnsml = Math.log(misc.d1mach(1));
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return a + b;
        }
        if (a < 0.0 || b < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (a == 0.0 || b == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(a) || Double.isInfinite(b)) {
            return 0.0;
        }
        if (a + b < xmax) {
            return misc.gammafn(a) * misc.gammafn(b) / misc.gammafn(a + b);
        }
        val = misc.lbeta(a, b);
        if (val < alnsml) {
            throw new ArithmeticException("Math Error: UNDERFLOW");
        }
        return Math.exp(val);
    }

    static int chebyshev_init(double[] dos, int nos, double eta) {
        if (nos < 1) {
            return 0;
        }
        double err2 = 0.0;
        int i = 0;
        int ii = 1;
        while (ii <= nos) {
            i = nos - ii;
            if ((err2 += Math.abs(dos[i])) > eta) {
                return i;
            }
            ++ii;
        }
        return i;
    }

    public static double chebyshev_eval(double x2, double[] a, int n) {
        if (n < 1 || n > 1000) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < -1.1 || x2 > 1.1) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double twox = x2 * 2.0;
        double b2 = 0.0;
        double b1 = 0.0;
        double b0 = 0.0;
        int i = 1;
        while (i <= n) {
            b2 = b1;
            b1 = b0;
            b0 = twox * b1 - b2 + a[n - i];
            ++i;
        }
        return (b0 - b2) * 0.5;
    }

    public static double lfastchoose(double n, double k) {
        return misc.lgammafn(n + 1.0) - misc.lgammafn(k + 1.0) - misc.lgammafn(n - k + 1.0);
    }

    public static double fastchoose(double n, double k) {
        return Math.exp(misc.lfastchoose(n, k));
    }

    public static double lchoose(double n, double k) {
        n = Math.floor(n + 0.5);
        k = Math.floor(k + 0.5);
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return n + k;
        }
        if (k < 0.0 || n < k) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return misc.lfastchoose(n, k);
    }

    public static double choose(double n, double k) {
        n = Math.floor(n + 0.5);
        k = Math.floor(k + 0.5);
        if (Double.isNaN(n) || Double.isNaN(k)) {
            return n + k;
        }
        if (k < 0.0 || n < k) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return Math.floor(Math.exp(misc.lfastchoose(n, k)) + 0.5);
    }

    public static double d1mach(int i) {
        switch (i) {
            case 1: {
                return Double.MIN_VALUE;
            }
            case 2: {
                return Double.MAX_VALUE;
            }
            case 3: {
                return Math.pow(misc.i1mach(10), -((double)misc.i1mach(14)));
            }
            case 4: {
                return Math.pow(misc.i1mach(10), 1.0 - (double)misc.i1mach(14));
            }
            case 5: {
                return Math.log(2.0) / Math.log(10.0);
            }
        }
        return 0.0;
    }

    public static double fcube(double x2) {
        return x2 * x2 * x2;
    }

    public static double fmax2(double x2, double y) {
        if (Double.isNaN(x2) || Double.isNaN(y)) {
            return x2 + y;
        }
        return x2 < y ? y : x2;
    }

    public static double fmin2(double x2, double y) {
        if (Double.isNaN(x2) || Double.isNaN(y)) {
            return x2 + y;
        }
        return x2 < y ? x2 : y;
    }

    public static double fmod(double x2, double y) {
        if (Double.isNaN(x2) || Double.isNaN(y)) {
            return x2 + y;
        }
        double quot = x2 / y;
        return x2 - (quot < 0.0 ? Math.ceil(quot) : Math.floor(quot)) * y;
    }

    public static double fprec(double x2, double digits) {
        if (Double.isNaN(x2) || Double.isNaN(digits)) {
            return x2 + digits;
        }
        if (Double.isInfinite(x2)) {
            return x2;
        }
        if (Double.isInfinite(digits)) {
            if (digits > 0.0) {
                return x2;
            }
            return 0.0;
        }
        if (x2 == 0.0) {
            return x2;
        }
        if ((digits = Math.floor(digits + 0.5)) > 15.0) {
            return x2;
        }
        if (digits < 1.0) {
            digits = 1.0;
        }
        double sgn = 1.0;
        if (x2 < 0.0) {
            sgn = -sgn;
            x2 = -x2;
        }
        double l10 = Math.log(x2) / Math.log(10.0);
        int e10 = (int)(digits - 1.0 - Math.floor(l10));
        double max10e = 308.25471555991675;
        if (Math.abs(l10) < 306.25471555991675) {
            double pow10 = Math.pow(10.0, e10);
            return sgn * Math.floor(x2 * pow10 + 0.5) / pow10;
        }
        boolean do_round = 308.25471555991675 - l10 >= Math.pow(10.0, -digits);
        int e2 = e10 > 0 ? 16 : -16;
        double p10 = Math.pow(10.0, e2);
        x2 *= p10;
        double P10 = Math.pow(10.0, (double)e10 - (double)e2);
        x2 *= P10;
        if (do_round) {
            x2 += 0.5;
        }
        x2 = Math.floor(x2) / p10;
        return sgn * x2 / P10;
    }

    private static double Rint(double x2) {
        double biggest = 4.503599627370496E15;
        if (x2 != x2) {
            return x2;
        }
        if (Math.abs(x2) >= 4.503599627370496E15) {
            return x2;
        }
        if (x2 >= 0.0) {
            double tmp = x2 + 4.503599627370496E15;
            return tmp - 4.503599627370496E15;
        }
        double tmp = x2 - 4.503599627370496E15;
        return tmp + 4.503599627370496E15;
    }

    public static double fround(double x2, double digits) {
        double intx;
        double maxdigits = 14.0;
        if (Double.isNaN(x2) || Double.isNaN(digits)) {
            return x2 + digits;
        }
        if (Double.isInfinite(x2)) {
            return x2;
        }
        if ((digits = Math.floor(digits + 0.5)) > 14.0) {
            digits = 14.0;
        }
        double pow10 = Math.pow(10.0, digits);
        double sgn = 1.0;
        if (x2 < 0.0) {
            sgn = -sgn;
            x2 = -x2;
        }
        if (digits > 0.0) {
            intx = Math.floor(x2);
            x2 -= intx;
        } else {
            intx = 0.0;
        }
        return sgn * (intx + Math.rint(x2 * pow10) / pow10);
    }

    public static double fsign(double x2, double y) {
        if (Double.isNaN(x2) || Double.isNaN(y)) {
            return x2 + y;
        }
        return y >= 0.0 ? Math.abs(x2) : -Math.abs(x2);
    }

    public static double fsquare(double x2) {
        return x2 * x2;
    }

    public static double ftrunc(double x2) {
        if (x2 >= 0.0) {
            return Math.floor(x2);
        }
        return Math.ceil(x2);
    }

    public static double gammafn(double x2) {
        int ngam = 0;
        double xmin = 0.0;
        double xmax = 0.0;
        double xsml = 0.0;
        double dxrel = 0.0;
        if (ngam == 0) {
            ngam = misc.chebyshev_init(gamcs, 42, 0.1 * misc.d1mach(3));
            double[] temp = misc.gammalims(xmin, xmax);
            xmin = temp[0];
            xmax = temp[1];
            xsml = Math.exp(misc.fmax2(Math.log(misc.d1mach(1)), -Math.log(misc.d1mach(2))) + 0.01);
            dxrel = Math.sqrt(misc.d1mach(4));
        }
        if (Double.isNaN(x2)) {
            return x2;
        }
        double y = Math.abs(x2);
        if (y <= 10.0) {
            int n = (int)x2;
            if (x2 < 0.0) {
                --n;
            }
            y = x2 - (double)n;
            double value2 = misc.chebyshev_eval(y * 2.0 - 1.0, gamcs, ngam) + 0.9375;
            if (--n == 0) {
                return value2;
            }
            if (n < 0) {
                if (x2 == 0.0 || x2 < 0.0 && x2 == (double)(n + 2)) {
                    throw new ArithmeticException("Math Error: RANGE");
                }
                if (x2 < -0.5 && Math.abs(x2 - (double)((int)(x2 - 0.5)) / x2) < dxrel) {
                    throw new ArithmeticException("Math Error: PRECISION");
                }
                if (y < xsml) {
                    throw new ArithmeticException("Math Error: RANGE");
                }
                n = -n;
                int i = 0;
                while (i < n) {
                    value2 /= x2 + (double)i;
                    ++i;
                }
                return value2;
            }
            int i = 1;
            while (i <= n) {
                value2 *= y + (double)i;
                ++i;
            }
            return value2;
        }
        if (x2 > xmax) {
            throw new ArithmeticException("Math Error: RANGE");
        }
        if (x2 < xmin) {
            throw new ArithmeticException("Math Error: UNDERFLOW");
        }
        double value3 = Math.exp((y - 0.5) * Math.log(y) - y + 0.9189385332046728 + misc.lgammacor(y));
        if (x2 > 0.0) {
            return value3;
        }
        if (Math.abs((x2 - (double)((int)(x2 - 0.5))) / x2) < dxrel) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        double sinpiy = Math.sin(Math.PI * y);
        if (sinpiy == 0.0) {
            throw new ArithmeticException("Math Error: RANGE");
        }
        return -Math.PI / (y * sinpiy * value3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double gamma_cody(double x2) {
        double res;
        double y1;
        double sqrtpi = 0.9189385332046728;
        double xbig = 171.624;
        double[] p = new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054};
        double[] q = new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349};
        double[] c = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        boolean parity = false;
        double fact = 1.0;
        long n = 0L;
        double y = x2;
        if (y <= 0.0) {
            y = -x2;
            y1 = misc.ftrunc(y);
            res = y - y1;
            if (res == 0.0) return Double.POSITIVE_INFINITY;
            if (y1 != misc.ftrunc(y1 * 0.5) * 2.0) {
                parity = true;
            }
            fact = -Math.PI / Math.sin(Math.PI * res);
            y += 1.0;
        }
        if (y < 2.220446049250313E-16) {
            if (!(y >= Double.MIN_VALUE)) return Double.POSITIVE_INFINITY;
            res = 1.0 / y;
        } else if (y < 12.0) {
            double z;
            y1 = y;
            if (y < 1.0) {
                z = y;
                y += 1.0;
            } else {
                n = (long)y - 1L;
                z = (y -= (double)n) - 1.0;
            }
            double xnum = 0.0;
            double xden = 1.0;
            long i = 0L;
            while (i < 8L) {
                xnum = (xnum + p[(int)i]) * z;
                xden = xden * z + q[(int)i];
                ++i;
            }
            res = xnum / xden + 1.0;
            if (y1 < y) {
                res /= y1;
            } else if (y1 > y) {
                i = 0L;
                while (i < n) {
                    res *= y;
                    y += 1.0;
                    ++i;
                }
            }
        } else {
            if (!(y <= 171.624)) return Double.POSITIVE_INFINITY;
            double ysq = y * y;
            double sum2 = c[6];
            long i = 0L;
            while (i < 6L) {
                sum2 = sum2 / ysq + c[(int)i];
                ++i;
            }
            sum2 = sum2 / y - y + 0.9189385332046728;
            res = Math.exp(sum2 += (y - 0.5) * Math.log(y));
        }
        if (parity) {
            res = -res;
        }
        if (fact == 1.0) return res;
        return fact / res;
    }

    static double[] gammalims(double xmin, double xmax) {
        block5: {
            double alnbig;
            double xln;
            double xold;
            int i;
            block4: {
                double alnsml = Math.log(misc.d1mach(1));
                xmin = -alnsml;
                i = 1;
                while (i <= 10) {
                    xold = xmin;
                    if (!(Math.abs((xmin -= xmin * ((xmin + 0.5) * (xln = Math.log(xmin)) - xmin - 0.2258 + alnsml) / (xmin * xln + 0.5)) - xold) < 0.005)) {
                        ++i;
                        continue;
                    }
                    break block4;
                }
                throw new ArithmeticException("Math Error: NOCONV");
            }
            xmin = -xmin + 0.01;
            xmax = alnbig = Math.log(misc.d1mach(2));
            i = 1;
            while (i <= 10) {
                xold = xmax;
                if (!(Math.abs((xmax -= xmax * ((xmax - 0.5) * (xln = Math.log(xmax)) - xmax + 0.9189 - alnbig) / (xmax * xln - 0.5)) - xold) < 0.005)) {
                    ++i;
                    continue;
                }
                break block5;
            }
            throw new ArithmeticException("Math Error: NOCONV");
        }
        xmin = misc.fmax2(xmin, -(xmax += -0.01) + 1.0);
        double[] retval = new double[]{xmin, xmax};
        return retval;
    }

    public static int i1mach(int i) {
        switch (i) {
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                throw new RuntimeException("Unimplemented Feature.");
            }
            case 6: {
                throw new RuntimeException("Unimplemented Feature.");
            }
            case 7: {
                return 2;
            }
            case 8: {
                throw new RuntimeException("Unimplemented Feature.");
            }
            case 9: {
                return Integer.MAX_VALUE;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 24;
            }
            case 12: {
                return -125;
            }
            case 13: {
                return 128;
            }
            case 14: {
                return 53;
            }
            case 15: {
                return 1024;
            }
            case 16: {
                return -1021;
            }
        }
        return 0;
    }

    int i1mach_(int i) {
        return misc.i1mach(i);
    }

    int imax2(int x2, int y) {
        return x2 < y ? y : x2;
    }

    int imin2(int x2, int y) {
        return x2 < y ? x2 : y;
    }

    public static double lbeta(double a, double b) {
        double q = a;
        double p = q;
        if (b < p) {
            p = b;
        }
        if (b > q) {
            q = b;
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return a + b;
        }
        if (p < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(q)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 10.0) {
            double corr = misc.lgammacor(p) + misc.lgammacor(q) - misc.lgammacor(p + q);
            return Math.log(q) * -0.5 + 0.9189385332046728 + corr + (p - 0.5) * Math.log(p / (p + q)) + q * misc.logrelerr(-p / (p + q));
        }
        if (q >= 10.0) {
            double corr = misc.lgammacor(q) - misc.lgammacor(p + q);
            return misc.lgammafn(p) + corr + p - p * Math.log(p + q) + (q - 0.5) * misc.logrelerr(-p / (p + q));
        }
        return Math.log(misc.gammafn(p) * (misc.gammafn(q) / misc.gammafn(p + q)));
    }

    public static double lgammafn(double x2) {
        double xmax = 0.0;
        double dxrel = 0.0;
        if (xmax == 0.0) {
            xmax = misc.d1mach(2) / Math.log(misc.d1mach(2));
            dxrel = Math.sqrt(misc.d1mach(4));
        }
        signgam = 1;
        if (Double.isNaN(x2)) {
            return x2;
        }
        if (x2 <= 0.0 && x2 == (double)((int)x2)) {
            throw new ArithmeticException("Math Error: RANGE");
        }
        double y = Math.abs(x2);
        if (y <= 10.0) {
            return Math.log(Math.abs(misc.gammafn(x2)));
        }
        if (y > xmax) {
            throw new ArithmeticException("Math Error: RANGE");
        }
        if (x2 > 0.0) {
            return 0.9189385332046728 + (x2 - 0.5) * Math.log(x2) - x2 + misc.lgammacor(y);
        }
        double sinpiy = Math.abs(Math.sin(Math.PI * y));
        if (sinpiy == 0.0) {
            System.out.println(" ** should NEVER happen! *** [lgamma.c: Neg.int+ y=%g]\n" + y);
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double ans = 0.22579135264472744 + (x2 - 0.5) * Math.log(y) - x2 - Math.log(sinpiy) - misc.lgammacor(y);
        if (Math.abs((x2 - (double)((int)(x2 - 0.5))) * ans / x2) < dxrel) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        if (x2 > 0.0) {
            return ans;
        }
        if ((int)(-x2) % 2 == 0) {
            signgam = -1;
        }
        return ans;
    }

    public static double lgammacor(double x2) {
        double[] algmcs = new double[]{0.16663894804518634, -1.384948176067564E-5, 9.81082564692473E-9, -1.809129475572494E-11, 6.221098041892606E-14, -3.399615005417722E-16, 2.683181998482699E-18, -2.868042435334643E-20, 3.9628370610464347E-22, -6.831888753985767E-24, 1.4292273559424982E-25, -3.5475981581010704E-27, 1.025680058010471E-28, -3.401102254316749E-30, 1.276642195630063E-31};
        int nalgm = 0;
        double xbig = 0.0;
        double xmax = 0.0;
        if (nalgm == 0) {
            nalgm = misc.chebyshev_init(algmcs, 15, misc.d1mach(3));
            xbig = 1.0 / Math.sqrt(misc.d1mach(3));
            xmax = Math.exp(misc.fmin2(Math.log(misc.d1mach(2) / 12.0), -Math.log(12.0 * misc.d1mach(1))));
        }
        if (x2 < 10.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 >= xmax) {
            throw new ArithmeticException("Math Error: UNDERFLOW");
        }
        if (x2 < xbig) {
            double tmp = 10.0 / x2;
            return misc.chebyshev_eval(tmp * tmp * 2.0 - 1.0, algmcs, nalgm) / x2;
        }
        return 1.0 / (x2 * 12.0);
    }

    public static double logrelerr(double x2) {
        double[] alnrcs = new double[]{1.037869356274377, -0.13364301504908918, 0.019408249135520562, -0.0030107551127535777, 4.869461479715485E-4, -8.105488189317536E-5, 1.3778847799559525E-5, -2.380221089435897E-6, 4.1640416213865184E-7, -7.359582837807599E-8, 1.3117611876241675E-8, -2.3546709317742423E-9, 4.2522773276035E-10, -7.71908941348408E-11, 1.407574648135907E-11, -2.5769072058024682E-12, 4.734240666629442E-13, -8.724901267474264E-14, 1.612461490274055E-14, -2.9875652015665774E-15, 5.548070120908289E-16, -1.0324619158271569E-16, 1.9250239203049852E-17, -3.595507346526515E-18, 6.726454253787686E-19, -1.260262416873522E-19, 2.364488440860621E-20, -4.4419377050807936E-21, 8.354659446403425E-22, -1.5731559416479563E-22, 2.9653128740247425E-23, -5.594958348181595E-24, 1.056635426883568E-24, -1.9972483680670205E-25, 3.778297781883936E-26, -7.153158688908174E-27, 1.3552488463674214E-27, -2.5694673048487566E-28, 4.8747756066216946E-29, -9.254211253084972E-30, 1.757859784176024E-30, -3.341002667773101E-31, 6.353393618023618E-32};
        int nlnrel = 0;
        double xmin = 0.0;
        if (nlnrel == 0) {
            nlnrel = misc.chebyshev_init(alnrcs, 43, 0.1 * misc.d1mach(3));
            xmin = -1.0 + Math.sqrt(misc.d1mach(4));
        }
        if (x2 <= -1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < xmin) {
            throw new ArithmeticException("Math Error: PRECISION");
        }
        if (Math.abs(x2) <= 0.375) {
            return x2 * (1.0 - x2 * misc.chebyshev_eval(x2 / 0.375, alnrcs, nlnrel));
        }
        return Math.log(x2 + 1.0);
    }

    public static double sign(double x2) {
        if (Double.isNaN(x2)) {
            return x2;
        }
        return x2 > 0.0 ? 1 : (x2 == 0.0 ? 0 : -1);
    }
}

