/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.chisquare;
import DistLib.misc;
import DistLib.normal;
import DistLib.uniform;

public class f {
    public static double density(double x2, double n1, double n2) {
        if (Double.isNaN(x2) || Double.isNaN(n1) || Double.isNaN(n2)) {
            return x2 + n1 + n2;
        }
        if (n1 <= 0.0 || n2 <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        double a = n1 / n2 * x2;
        return Math.pow(a, 0.5 * n1) * Math.pow(1.0 + a, -0.5 * (n1 + n2)) / (x2 * misc.beta(0.5 * n1, 0.5 * n2));
    }

    public static double cumulative(double x2, double n1, double n2) {
        if (Double.isNaN(x2) || Double.isNaN(n1) || Double.isNaN(n2)) {
            return x2 + n2 + n1;
        }
        if (n1 <= 0.0 || n2 <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        return !Double.isNaN(x2 = 1.0 - beta.cumulative(n2 / (n2 + n1 * x2), n2 / 2.0, n1 / 2.0)) ? x2 : Double.NaN;
    }

    public static double quantile(double x2, double n1, double n2) {
        if (Double.isNaN(x2) || Double.isNaN(n1) || Double.isNaN(n2)) {
            return x2 + n1 + n2;
        }
        if (n1 <= 0.0 || n2 <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        return !Double.isNaN(x2 = (1.0 / beta.quantile(1.0 - x2, n2 / 2.0, n1 / 2.0) - 1.0) * (n2 / n1)) ? x2 : Double.NaN;
    }

    public static double random(double n1, double n2, uniform PRNG) {
        if (Double.isNaN(n1) || Double.isNaN(n2) || n1 <= 0.0 || n2 <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        double v1 = !Double.isInfinite(n1) ? chisquare.random(n1, PRNG) / n1 : normal.random(PRNG);
        double v2 = !Double.isInfinite(n2) ? chisquare.random(n2, PRNG) / n2 : normal.random(PRNG);
        return v1 / v2;
    }
}

