/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import org.forester.util.ForesterUtil;

public final class GapContribution
implements Comparable<GapContribution> {
    private final String _id;
    private double _value;

    GapContribution(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("id is empty or null");
        }
        this._id = string;
        this._value = 0.0;
    }

    final String getId() {
        return this._id;
    }

    final double getValue() {
        return this._value;
    }

    final void addToValue(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("cannot add negative value");
        }
        this._value += d;
    }

    final void divideValue(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("attempt to divide by non-positive value");
        }
        this._value /= d;
    }

    @Override
    public int compareTo(GapContribution gapContribution) {
        if (this.getValue() < gapContribution.getValue()) {
            return 1;
        }
        if (this.getValue() > gapContribution.getValue()) {
            return -1;
        }
        return 0;
    }
}

