/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.AbstractCoordSystem;
import com.approximatrix.charting.coordsystem.ClassicCoordSystemUtilities;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;

public class ClassicCoordSystem
extends AbstractCoordSystem
implements ChartDataModelListener {
    protected final FontRenderContext frc = new FontRenderContext(null, false, false);
    protected boolean shouldDrawArrows = true;
    protected boolean shouldPaintAltTick = true;
    public final int MINIMALMARGIN = 20;
    public final int ARROWLENGTH = 15;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    protected ClassicCoordSystemUtilities c;

    public ClassicCoordSystem(ChartDataModel cdm) {
        this.constraints = cdm.getChartDataModelConstraints(0);
        this.constraints2 = cdm.getChartDataModelConstraints(1);
        this.model = cdm;
        this.xaxis = new Axis(1, this.constraints);
        this.yaxis = new Axis(2, this.constraints);
        this.c = new ClassicCoordSystemUtilities(this, this.constraints, this.constraints2, this.model);
        this.dfY = new DecimalFormat();
        this.dfX = new DecimalFormat();
        cdm.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !cdm.isColumnNumeric();
    }

    public ClassicCoordSystem(ChartDataModel c, String xunit, String yunit) {
        this(c);
        this.setXAxisUnit(xunit);
        this.setYAxisUnit(yunit);
        c.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !c.isColumnNumeric();
    }

    public ClassicCoordSystem(ChartDataModel c, DecimalFormat yAxisFormat, boolean drawArrows, boolean paintAltYTick, boolean paintOnlyYTick) {
        this(c);
        this.dfY = yAxisFormat;
        this.shouldDrawArrows = drawArrows;
        this.shouldPaintAltTick = paintAltYTick;
        this.shouldPaintOnlyTick = paintOnlyYTick;
        c.addChartDataModelListener(this);
        this.centerObjectLabelsBetweenTicks = !c.isColumnNumeric();
    }

    public boolean isPaintAltTick() {
        return this.shouldPaintAltTick;
    }

    @Override
    public void paintDefault(Graphics2D g) {
        if (!this.shouldPaintAxes) {
            return;
        }
        g.setColor(Color.black);
        Line2D x = this.c.getXAxisLine2D();
        Line2D y = this.c.getYAxisLine2D();
        g.draw(x);
        g.draw(y);
        if (this.shouldPaintGrid) {
            this.c.drawYAxisGrid(g);
            if (this.model.isColumnNumeric()) {
                this.c.drawNumericalXAxisGrid(g);
            }
        }
        if (this.shouldDrawArrows) {
            g.drawLine((int)x.getX2(), (int)x.getY2(), (int)x.getX2() + 15, (int)x.getY2());
            g.fillPolygon(new int[]{(int)(x.getX2() + 5.0), (int)(x.getX2() + 5.0), (int)(x.getX2() + 15.0)}, new int[]{(int)x.getY2() - 3, (int)x.getY2() + 3, (int)x.getY2()}, 3);
        }
        g.setColor(Color.black);
        TextLayout layoutX = new TextLayout(this.getXAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        layoutX.draw(g, (float)x.getX2() + 5.0f, (float)x.getY2() + (float)layoutX.getBounds().getHeight() + 5.0f);
        if (this.shouldDrawArrows) {
            g.drawLine((int)y.getX1(), (int)y.getY1(), (int)y.getX1(), (int)y.getY1() - 15);
            g.fillPolygon(new int[]{(int)(y.getX1() - 3.0), (int)(y.getX1() + 3.0), (int)y.getX1()}, new int[]{(int)(y.getY1() - 5.0), (int)(y.getY1() - 5.0), (int)y.getY1() - 15}, 3);
        }
        g.setColor(Color.black);
        TextLayout layoutY = new TextLayout(this.getYAxisUnit(), this.getUnitFont(), new FontRenderContext(null, true, false));
        layoutY.draw(g, (float)y.getX1() - 6.0f - (float)layoutY.getBounds().getWidth(), (float)y.getY1() - layoutX.getDescent() - 3.0f);
        if (this.getSecondYAxis() != null) {
            Line2D y2 = this.c.getSecondYAxisLine2D();
            g.draw(y2);
        }
        if (this.model.isColumnNumeric()) {
            this.c.drawNumericalXAxisTicks(g);
        } else {
            this.c.drawXAxisTicks(g);
        }
        this.c.drawYAxisTicks(g);
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public DecimalFormat getYDecimalFormat() {
        return this.dfY;
    }

    @Override
    public DecimalFormat getXDecimalFormat() {
        return this.dfX;
    }

    public boolean isDrawArrows() {
        return this.shouldDrawArrows;
    }

    @Override
    public ChartDataModelConstraints getChartDataModelConstraints(int axis) {
        if (axis == 0) {
            return this.constraints;
        }
        if (axis == 1) {
            return this.constraints2;
        }
        return null;
    }

    @Override
    public void setMaximumXTicks(int value) {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumXTicks(value);
        super.fireRenderChangeEvent();
    }

    @Override
    public void setMaximumYTicks(int value) {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumYTicks(value);
        super.fireRenderChangeEvent();
    }

    @Override
    public int getMaximumXTicks() {
        if (this.c == null) {
            return 0;
        }
        return this.c.getMaximumXTicks();
    }

    @Override
    public int getMaximumYTicks() {
        if (this.c == null) {
            return 0;
        }
        return this.c.getMaximumYTicks();
    }

    @Override
    public void resetMaximumXTicks() {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumXTicks(-1);
    }

    @Override
    public void resetMaximumYTicks() {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumYTicks(-1);
    }

    @Override
    public void chartDataChanged(ChartDataModelEvent evt) {
        this.setTransforms();
    }

    @Override
    protected int computeBottomMargin() {
        return this.c.computeBottomMargin();
    }

    @Override
    protected int computeLeftMargin() {
        return this.c.computeLeftMargin();
    }

    @Override
    protected int computeRightMargin() {
        return this.c.computeRightMargin();
    }

    @Override
    protected int computeTopMargin() {
        return this.c.computeTopMargin();
    }

    @Override
    public void setCenterLabelsBetweenTicks(boolean value) {
        if (this.model.isColumnNumeric() && value) {
            throw new IllegalArgumentException("ClassicCoordSystem does not support centering numeric X-axis labels.");
        }
        super.setCenterLabelsBetweenTicks(value);
    }
}

