/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.gateTableCellRenderer;
import FCSalyzer.GUI.gateTableModel;
import FCSalyzer.GUI.regionTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;

public class regionGateDialog
extends WindowAdapter
implements ActionListener,
TableModelListener {
    private FCS_RegionGatesHolder theRaG;
    private JButton CLOSE_Button = new JButton("Close");
    private JButton DelRegion_Button = new JButton("Delete region");
    private JButton AddGate_Button = new JButton("Add gate");
    private JButton DelGate_Button = new JButton("Delete gate");
    private JDialog theDialog = new JDialog();
    private gateTableModel theGateModel;
    private JTable regionTable;
    private JTable gateTable;
    private FACS_document theDocument;
    public static final String UP = "\u02c4";
    public static final String DOWN = "\u02c5";

    private regionGateDialog() {
    }

    public regionGateDialog(FCS_RegionGatesHolder paramRaG, FACS_document paramDoc) {
        this.theRaG = paramRaG;
        this.theDocument = paramDoc;
        this.theDialog.setModal(true);
        this.theDialog.setTitle("Adjust Regions and Gates");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.DelRegion_Button);
        buttonPanel.add(this.AddGate_Button);
        buttonPanel.add(this.DelGate_Button);
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.addActionListener(this);
        this.DelRegion_Button.addActionListener(this);
        this.AddGate_Button.addActionListener(this);
        this.DelGate_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(1);
        JSplitPane splitter = new JSplitPane(0);
        this.regionTable = new JTable(new regionTableModel(this.theRaG, this));
        this.regionTable.setSelectionMode(0);
        JScrollPane regionScroller = new JScrollPane(this.regionTable);
        splitter.setTopComponent(regionScroller);
        this.theGateModel = new gateTableModel(this.theRaG.getGates());
        this.theGateModel.addTableModelListener(this);
        this.gateTable = new JTable(this.theGateModel);
        gateTableCellRenderer gR = new gateTableCellRenderer(this.theGateModel);
        this.gateTable.getColumn(UP).setCellRenderer(gR);
        this.gateTable.getColumn(UP).setMaxWidth(30);
        this.gateTable.getColumn(DOWN).setCellRenderer(gR);
        this.gateTable.getColumn(DOWN).setMaxWidth(30);
        this.gateTable.getColumn("Decoded").setCellRenderer(gR);
        this.gateTable.getColumn("Strategy").setCellRenderer(gR);
        this.gateTable.getColumn("Gate Name").setCellRenderer(gR);
        gateTableCellEditor edi = new gateTableCellEditor();
        this.gateTable.getColumn("Color").setCellEditor(edi);
        this.gateTable.getColumn("Color").setMaxWidth(40);
        gateUpDownCellEditor edi2 = new gateUpDownCellEditor();
        this.gateTable.getColumn(UP).setCellEditor(edi2);
        this.gateTable.getColumn(DOWN).setCellEditor(edi2);
        JScrollPane gateScroller = new JScrollPane(this.gateTable);
        splitter.setBottomComponent(gateScroller);
        this.theDialog.add((Component)splitter, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(400, 400);
        splitter.setDividerLocation(100);
        splitter.setDividerSize(3);
    }

    public void showDialog() {
        this.theDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.CLOSE_Button) {
            this.theDialog.setVisible(false);
        } else if (e.getSource() == this.DelRegion_Button) {
            int selected = this.regionTable.getSelectedRow();
            if (selected > -1) {
                this.theRaG.deleteRegion(this.theRaG.getRegion(selected));
                this.regionTable.setModel(new regionTableModel(this.theRaG, this));
                this.theGateModel.setGates(this.theRaG.getGates());
                this.theDocument.refreshView(true);
            }
        } else if (e.getSource() == this.DelGate_Button) {
            int selected = this.gateTable.getSelectedRow();
            if (selected > -1) {
                FCS_gate delGate = this.theRaG.getGate(selected);
                this.theRaG.deleteGate(delGate);
                this.theGateModel.setGates(this.theRaG.getGates());
                this.theDocument.gateDeleted(delGate);
            }
        } else if (e.getSource() == this.AddGate_Button) {
            this.theRaG.add(new FCS_gate("G" + this.theRaG.getGatesCount(), this.theRaG));
            this.theGateModel.setGates(this.theRaG.getGates());
        }
    }

    public void dispose() {
        this.theDialog.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        int end;
        int start;
        int col = event.getColumn();
        if (col == 0 && (start = event.getFirstRow()) == (end = event.getLastRow())) {
            this.theRaG.moveGate(start, -1);
            this.theGateModel.setGates(this.theRaG.getGates());
        }
        if (col == 1 && (start = event.getFirstRow()) == (end = event.getLastRow())) {
            this.theRaG.moveGate(start, 1);
            this.theGateModel.setGates(this.theRaG.getGates());
        }
        this.theDocument.refreshView(true);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theDialog.setVisible(false);
    }

    public void updateGateTable() {
        this.theGateModel.setGates(this.theRaG.getGates());
    }

    private class gateUpDownCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JButton theButton = new JButton();

        public gateUpDownCellEditor() {
            this.theButton.addActionListener(this);
            this.theButton.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Object getCellEditorValue() {
            return this.theButton.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.theButton.setText(value.toString());
            return this.theButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    private class gateTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JColorChooser theChooser = new JColorChooser();
        private JButton theButton = new JButton();
        private JDialog theDialog = JColorChooser.createDialog(this.theButton, "Choose a Color", true, this.theChooser, this, null);
        private static final String EDIT = "edit";
        private int color;

        public gateTableCellEditor() {
            this.theButton.addActionListener(this);
            this.theButton.setActionCommand(EDIT);
        }

        @Override
        public Object getCellEditorValue() {
            return this.color;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ImageIcon) {
                this.theButton.setIcon((ImageIcon)value);
                Image img = ((ImageIcon)value).getImage();
                if (img instanceof BufferedImage) {
                    this.color = ((BufferedImage)img).getRGB(0, 0);
                }
            }
            return this.theButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(EDIT)) {
                this.theChooser.setColor(this.color);
                this.theDialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.color = this.theChooser.getColor().getRGB();
            }
        }
    }
}

