/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.util.DOMUtils;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneeSheet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AssigneeSheetBuilder
implements ErrorHandler {
    public AssigneeSheet createAssigneeSheet() {
        Document document = this.createDocument();
        DOMUtils.createElement((Node)document, (String)"assignee-sheet");
        AssigneeSheet sheet = new AssigneeSheet(document);
        return sheet;
    }

    private Document createDocument() {
        return this.getDocumentCreator().newDocument();
    }

    private DocumentBuilder getDocumentCreator() {
        DocumentBuilder builder = null;
        try {
            builder = DOMUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return builder;
    }

    public AssigneeSheet loadFromFile(File file) throws IOException, CoreException {
        AssigneeSheet assigneeSheet;
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            assigneeSheet = this.loadFromStream(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {}
        return assigneeSheet;
    }

    public AssigneeSheet loadFromStream(InputStream stream) throws IOException, CoreException {
        DocumentBuilder loader = this.getDocumentLoader();
        Document doc = this.parse(loader, stream);
        return this.createAssigneeSheet(doc);
    }

    private AssigneeSheet createAssigneeSheet(Document document) {
        AssigneeSheet sheet = new AssigneeSheet(document);
        this.init(sheet);
        return sheet;
    }

    private void init(AssigneeSheet sheet) {
        for (AssigneeItem item : sheet.getAssignees()) {
            this.initItem(item);
        }
    }

    private void initItem(AssigneeItem item) {
    }

    private DocumentBuilder getDocumentLoader() throws CoreException {
        DocumentBuilder documentLoader = null;
        try {
            documentLoader = DOMUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(12, (Throwable)e);
        }
        documentLoader.setErrorHandler(this);
        return documentLoader;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parse(DocumentBuilder loader, InputStream stream) throws IOException, CoreException {
        Document document;
        try {
            document = loader.parse(stream);
        }
        catch (SAXException e) {
            try {
                throw new CoreException(13, (Throwable)e);
                catch (IOException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return document;
        }
        catch (IOException iOException) {}
        return document;
    }

    public void error(SAXParseException exception) throws SAXException {
        Core.getLogger().log((Throwable)exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Core.getLogger().log((Throwable)exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        Core.getLogger().log((Throwable)exception);
    }
}

