/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xmind.core.IBoundary;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.AbstractWorkbookComponent;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Topic
extends AbstractWorkbookComponent
implements ITopic {
    protected static final List<ITopic> NO_CHILDREN = Collections.emptyList();
    protected static final Set<String> NO_TYPES = Collections.emptySet();
    protected static final Set<IMarkerRef> NO_MARKER_REFS = Collections.emptySet();
    protected static final Set<IBoundary> NO_BOUNDARIES = Collections.emptySet();
    protected static final Set<ISummary> NO_SUMMARIES = Collections.emptySet();
    protected static final Set<String> NO_LABELS = Collections.emptySet();

    @Override
    public String getStyleType() {
        return "topic";
    }

    @Override
    public String getTitleText() {
        String t = this.getLocalTitleText();
        return t == null ? "" : t;
    }

    @Override
    public boolean hasTitle() {
        return this.getLocalTitleText() != null;
    }

    @Override
    public void setPosition(Point position) {
        if (position == null) {
            this.removePosition();
        } else {
            this.setPosition(position.x, position.y);
        }
    }

    @Override
    public boolean hasPosition() {
        return this.getPosition() != null;
    }

    @Override
    public List<ITopic> getAllChildren() {
        Set<String> types = this.getChildrenTypes();
        ArrayList<ITopic> all = new ArrayList<ITopic>(types.size() * 10);
        for (String type : types) {
            all.addAll(this.getChildren(type));
        }
        return all;
    }

    @Override
    public boolean isAttached() {
        return "attached".equals(this.getType());
    }

    @Override
    public int getIndex() {
        ITopic parent = this.getParent();
        if (parent != null) {
            return parent.getChildren(this.getType()).indexOf(this);
        }
        return -1;
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.getPath().getSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.getPath().getWorkbook();
    }

    protected abstract String getLocalTitleText();

    protected abstract void removePosition();

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISheet.class) {
            return adapter.cast(this.getOwnedSheet());
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return "TOPIC (" + this.getTitleText() + ")";
    }
}

