/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmind.core.io.IStorage;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.MonitoredOutputTarget;
import org.xmind.seawind.internal.core.SSerializable;
import org.xmind.seawind.internal.core.SeawindWorkbook;

public class SeawindWorkingSet
implements SSerializable {
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private final List<SeawindWorkbook> workbooks = new ArrayList<SeawindWorkbook>();
    private IStorage storage = null;
    private String path = null;
    private String debugName = null;

    public SeawindWorkingSet(JSONObject json) {
        this.loadWorkbooks(json.optJSONArray("workbooks"));
    }

    private void loadWorkbooks(JSONArray workbookArray) {
        if (workbookArray == null) {
            return;
        }
        for (Object o : workbookArray) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject workbookObject = (JSONObject)o;
            SeawindWorkbook workbook = new SeawindWorkbook(workbookObject);
            workbook.setParent(this);
            this.workbooks.add(workbook);
        }
    }

    private Properties captureProperties() {
        Properties properties = new Properties();
        properties.put("workbooks", new ArrayList<SeawindWorkbook>(this.workbooks));
        return properties;
    }

    private void notifyPropertiesChange(Properties oldProperties, boolean updateModificationTime) {
        Properties newProperties = this.captureProperties();
        for (String propertyName : Arrays.asList("workbooks", "modificationTime")) {
            this.propertySupport.firePropertyChange(propertyName, oldProperties.get(propertyName), newProperties.get(propertyName));
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject object = new JSONObject();
        JSONArray workbookArray = new JSONArray();
        for (SeawindWorkbook workbook : this.workbooks) {
            workbookArray.put((Object)workbook.toJSON());
        }
        object.put("workbooks", (Object)workbookArray);
        return object;
    }

    public PropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }

    public List<SeawindWorkbook> getWorkbooks() {
        return Collections.unmodifiableList(this.workbooks);
    }

    public void removeAllWorkbooks() {
        Properties oldProperties = this.captureProperties();
        this.workbooks.clear();
        this.notifyPropertiesChange(oldProperties, true);
    }

    public void addWorkbook(SeawindWorkbook workbook) {
        Properties oldProperties = this.captureProperties();
        this.workbooks.add(workbook);
        workbook.setParent(this);
        this.notifyPropertiesChange(oldProperties, true);
    }

    public void removeWorkbook(SeawindWorkbook workbook) {
        Properties oldProperties = this.captureProperties();
        this.workbooks.remove(workbook);
        this.notifyPropertiesChange(oldProperties, true);
        workbook.setParent(null);
    }

    public void moveWorkbook(SeawindWorkbook workbook, int newIndex) {
        Properties oldProperties = this.captureProperties();
        this.workbooks.remove(workbook);
        if (newIndex < 0) {
            this.workbooks.add(workbook);
        } else {
            this.workbooks.add(newIndex, workbook);
        }
        workbook.setParent(this);
        this.notifyPropertiesChange(oldProperties, true);
    }

    public SeawindWorkbook findWorkbook(String id) {
        int index = this.findWorkbookIndex(id);
        if (index < 0) {
            return null;
        }
        return this.workbooks.get(index);
    }

    private int findWorkbookIndex(String id) {
        if (id == null) {
            return -1;
        }
        ListIterator<SeawindWorkbook> it = this.workbooks.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            SeawindWorkbook workbook = it.next();
            if (!id.equals(workbook.getId())) continue;
            return index;
        }
        return -1;
    }

    public boolean isSameWith(SeawindWorkingSet that) {
        Iterator<SeawindWorkbook> thisWorkbookIt = this.workbooks.iterator();
        Iterator<SeawindWorkbook> thatWorkbookIt = that.workbooks.iterator();
        while (thisWorkbookIt.hasNext() && thatWorkbookIt.hasNext()) {
            SeawindWorkbook thatWorkbook;
            SeawindWorkbook thisWorkbook = thisWorkbookIt.next();
            if (thisWorkbook.isSameWith(thatWorkbook = thatWorkbookIt.next())) continue;
            return false;
        }
        return !thisWorkbookIt.hasNext() && !thatWorkbookIt.hasNext();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDebugName() {
        return this.debugName;
    }

    public void setDebugName(String debugName) {
        this.debugName = debugName;
    }

    public String toString() {
        return this.toJSON().toString(4);
    }

    public boolean save(IProgressMonitor monitor) throws InterruptedException, IOException {
        if (this.storage == null || this.path == null) {
            return false;
        }
        try {
            JSON.writeObject(this.toJSON(), new MonitoredOutputTarget(this.storage.getOutputTarget(), monitor), this.path);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        return true;
    }
}

