/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.Workbook;

public class ResourceRef
implements IResourceRef {
    private final Workbook ownerWorkbook;
    private final String resourceType;
    private final String resourceId;
    private boolean orphan;

    public ResourceRef(Workbook ownerWorkbook, String resourceType, String resourceId) {
        this.ownerWorkbook = ownerWorkbook;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Object getResource() {
        String type = this.getType();
        if ("file-entry".equals(type)) {
            return this.getFileEntry();
        }
        return null;
    }

    protected void onParented() {
        this.orphan = false;
    }

    protected void onOrphan() {
        this.orphan = true;
    }

    protected IFileEntry getFileEntry() {
        String entryPath = this.getResourceId();
        return this.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
    }
}

