/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.ShadowFigure;
import org.xmind.gef.service.AbstractShadowService;

public class ShadowService
extends AbstractShadowService {
    private Map<IFigure, ShadowFigure> map = new HashMap<IFigure, ShadowFigure>();

    public ShadowService(IGraphicalViewer viewer) {
        super(viewer);
    }

    public void setLayer(IFigure layer) {
        if (layer == this.getLayer()) {
            return;
        }
        this.removeFiguresFromLayer();
        super.setLayer(layer);
        this.addFiguresToLayer();
    }

    private void addFiguresToLayer() {
        if (this.getLayer() == null) {
            return;
        }
        for (ShadowFigure shadow : this.map.values()) {
            this.getLayer().add((IFigure)shadow);
        }
    }

    private void removeFiguresFromLayer() {
        if (this.getLayer() == null) {
            return;
        }
        for (ShadowFigure shadow : this.map.values()) {
            if (this.getLayer() != shadow.getParent()) continue;
            this.getLayer().remove((IFigure)shadow);
        }
    }

    public void addShadow(IFigure source, int alpha, Dimension offset) {
        this.removeShadow(source);
        ShadowFigure shadow = new ShadowFigure();
        shadow.setSource(source);
        shadow.setAlpha(alpha);
        shadow.setOffset(offset.width, offset.height);
        this.map.put(source, shadow);
        if (this.getLayer() != null && this.isActive()) {
            this.getLayer().add((IFigure)shadow);
        }
    }

    public void removeShadow(IFigure source) {
        ShadowFigure shadow = this.map.remove(source);
        if (shadow == null) {
            return;
        }
        shadow.setSource(null);
        if (this.getLayer() == shadow.getParent()) {
            this.getLayer().remove((IFigure)shadow);
        }
    }

    protected void activate() {
        super.activate();
        if (this.getLayer() != null) {
            for (ShadowFigure shadow : this.map.values()) {
                this.getLayer().add((IFigure)shadow);
            }
        }
    }

    protected void deactivate() {
        super.deactivate();
        if (this.getLayer() != null) {
            for (ShadowFigure shadow : this.map.values()) {
                if (this.getLayer() != shadow.getParent()) continue;
                this.getLayer().remove((IFigure)shadow);
            }
        }
    }
}

