/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.cathy.internal.renderer.XRightTrimBarLayout;

public class XTrimmedPartLayout
extends TrimmedPartLayout {
    public Control headerSeparator;
    public Control footerSeparator;
    public Map<Object, Composite> containers = new HashMap<Object, Composite>();

    public XTrimmedPartLayout(Composite parent) {
        super(parent);
        this.clientArea.setVisible(false);
    }

    public void createHeaderSeparator(Composite parent) {
        if (this.headerSeparator != null) {
            return;
        }
        this.headerSeparator = new Label(parent, 258);
        this.headerSeparator.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XTrimmedPartLayout.this.headerSeparator = null;
            }
        });
    }

    public void createFooterSeparator(Composite parent) {
        if (this.footerSeparator != null) {
            return;
        }
        this.footerSeparator = new Label(parent, 258);
        this.footerSeparator.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                XTrimmedPartLayout.this.footerSeparator = null;
            }
        });
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle newBounds;
        Rectangle ca = composite.getClientArea();
        Rectangle caRect = new Rectangle(ca.x, ca.y, ca.width, ca.height);
        if (this.top != null && this.top.isVisible()) {
            Point topSize = this.top.computeSize(caRect.width - (Util.isMac() ? 12 : 0), -1, true);
            caRect.y += topSize.y;
            caRect.height -= topSize.y;
            newBounds = new Rectangle(ca.x, ca.y, caRect.width, topSize.y);
            if (!newBounds.equals((Object)this.top.getBounds())) {
                this.top.setBounds(newBounds);
            }
        }
        if (this.headerSeparator != null && this.headerSeparator.isVisible()) {
            Point underTopSize = this.headerSeparator.computeSize(caRect.width, -1, true);
            caRect.y += underTopSize.y;
            caRect.height -= underTopSize.y;
            newBounds = new Rectangle(caRect.x, caRect.y - underTopSize.y, caRect.width, underTopSize.y);
            if (!newBounds.equals((Object)this.headerSeparator.getBounds())) {
                this.headerSeparator.setBounds(newBounds);
            }
        }
        caRect.y += this.gutterTop;
        caRect.height -= this.gutterTop;
        if (this.bottom != null && this.bottom.isVisible()) {
            Point bottomSize = this.bottom.computeSize(caRect.width, -1, true);
            caRect.height -= bottomSize.y;
            newBounds = new Rectangle(caRect.x, caRect.y + caRect.height, caRect.width, bottomSize.y);
            if (!newBounds.equals((Object)this.bottom.getBounds())) {
                this.bottom.setBounds(newBounds);
            }
        }
        if (this.footerSeparator != null && this.footerSeparator.isVisible()) {
            Point aboveBottomSize = this.footerSeparator.computeSize(caRect.width, -1, true);
            caRect.height -= aboveBottomSize.y;
            newBounds = new Rectangle(caRect.x, caRect.y + caRect.height, caRect.width, aboveBottomSize.y);
            if (!newBounds.equals((Object)this.footerSeparator.getBounds())) {
                this.footerSeparator.setBounds(newBounds);
            }
        }
        caRect.height -= this.gutterBottom;
        if (this.left != null && this.left.isVisible()) {
            Point leftSize = this.left.computeSize(-1, caRect.height, true);
            caRect.x += leftSize.x;
            caRect.width -= leftSize.x;
            newBounds = new Rectangle(caRect.x - leftSize.x, caRect.y, leftSize.x, caRect.height);
            if (!newBounds.equals((Object)this.left.getBounds())) {
                this.left.setBounds(newBounds);
            }
        }
        caRect.x += this.gutterLeft;
        caRect.width -= this.gutterLeft;
        if (this.right != null && this.right.isVisible()) {
            Point rightSize = this.right.computeSize(-1, caRect.height, true);
            caRect.width -= rightSize.x;
            newBounds = new Rectangle(caRect.x + caRect.width, caRect.y, rightSize.x, caRect.height);
            if (!newBounds.equals((Object)this.right.getBounds())) {
                this.right.setBounds(newBounds);
            }
        }
        caRect.width -= this.gutterRight;
        if (this.clientArea.isVisible() && !caRect.equals((Object)this.clientArea.getBounds())) {
            this.clientArea.setBounds(caRect);
        }
        for (Composite container : this.containers.values()) {
            if (container == null || container.isDisposed() || !container.isVisible() || ca.equals((Object)container.getBounds())) continue;
            container.setBounds(ca);
        }
    }

    public Composite getContainer(Composite parent, final Object child) {
        Composite container = this.containers.get(child);
        if (container == null || container.isDisposed()) {
            container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Composite c = XTrimmedPartLayout.this.containers.get(child);
                    if (c != e.widget) {
                        XTrimmedPartLayout.this.containers.remove(child);
                    }
                }
            });
            this.containers.put(child, container);
        }
        return container;
    }

    public void removeContainer(Object child) {
        Composite container = this.containers.remove(child);
        if (container != null) {
            container.dispose();
        }
    }

    public Composite getTrimComposite(Composite parent, int side) {
        if (side == 131072) {
            if (this.right == null) {
                this.right = new Composite(parent, 0);
                this.right.setLayout((Layout)new XRightTrimBarLayout());
                this.right.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        XTrimmedPartLayout.this.right = null;
                    }
                });
            }
            return this.right;
        }
        Composite trim = super.getTrimComposite(parent, side);
        if (trim != null && this.clientArea != null && !this.clientArea.isDisposed()) {
            trim.setVisible(this.clientArea.isVisible());
        }
        return trim;
    }
}

