/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.handlers.WizardHandler;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.dashboard.DashboardContent;
import org.xmind.cathy.internal.dashboard.DashboardStyleProvider;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.dashboard.pages.IDashboardPage;
import org.xmind.ui.internal.e4handlers.DisabledHandler;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.util.IStyleProvider;

public class DashboardPart
implements IDashboardContext {
    private static final String PERSISTED_STATE_KEY_PREFIX = "org.xmind.cathy.dashboard/";
    private static final String[] AVAILABLE_COMMAND_IDS = new String[]{"org.xmind.ui.command.showDashboard", "org.xmind.ui.command.toggleDashboard", "org.xmind.ui.command.welcome", "org.xmind.ui.command.openWorkbook", "org.xmind.ui.command.openHomeMap", "org.xmind.ui.command.newWorkbook", "org.xmind.ui.command.newFromTemplate", "org.xmind.ui.command.clearWorkbookHistory", "net.xmind.ui.command.checkForUpdates", "net.xmind.ui.command.subscribeNewsletter", "net.xmind.ui.command.feedback", "net.xmind.ui.command.signIn", "net.xmind.ui.command.signOut", "net.xmind.ui.command.activatePro", "net.xmind.ui.command.goFeaturedMaps", "org.xmind.ui.command.showModelPart", "org.eclipse.ui.newWizard", "org.eclipse.ui.file.import", "org.eclipse.ui.file.restartWorkbench", "org.eclipse.ui.file.exit", "org.eclipse.ui.file.closePart", "org.eclipse.ui.window.preferences", "org.eclipse.ui.views.showView", "org.eclipse.ui.window.resetPerspective", "org.eclipse.ui.window.activateEditor", "org.eclipse.ui.window.nextEditor", "org.eclipse.ui.window.nextView", "org.eclipse.ui.window.previousEditor", "org.eclipse.ui.window.previousView", "org.eclipse.ui.help.helpContents", "org.eclipse.ui.help.aboutAction", "org.eclipse.ui.window.showKeyAssist"};
    @Inject
    private IEclipseContext context;
    @Inject
    private MPart partModel;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EMenuService menuService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    private MTabFolder tabFolder;
    private Set<String> availableCommandIds;
    private DashboardContent content;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            DashboardPart.this.handleSelectionChanged(event);
        }
    };

    protected IEclipseContext getContext() {
        return this.context;
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.context.set(IDashboardContext.class, (Object)this);
        this.tabFolder = new MTabFolder(parent);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.tabFolder);
        this.tabFolder.setStyleProvider((IStyleProvider)new DashboardStyleProvider((ResourceManager)resourceManager));
        this.tabFolder.setBackground(parent.getDisplay().getSystemColor(37));
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DashboardPart.this.handlePageSelected();
            }
        });
        this.availableCommandIds = new HashSet<String>();
        this.availableCommandIds.addAll(Arrays.asList(AVAILABLE_COMMAND_IDS));
        this.content = new DashboardContent(this, this.tabFolder);
        this.disableUnwantedCommands();
    }

    private void handlePageSelected() {
        if (this.tabFolder == null || this.content == null) {
            return;
        }
        MTabItem item = this.tabFolder.getSelection();
        String pageId = item == null ? null : this.content.getItemId(item);
        this.partModel.getTransientData().put("org.xmind.ui.part.dashboard.selectedPageId", pageId);
    }

    protected void executeCommand(String commandId, Map<String, Object> parameters) {
        if (this.commandService == null || this.handlerService == null) {
            return;
        }
        ParameterizedCommand command = this.commandService.createCommand(commandId, parameters);
        if (command == null) {
            return;
        }
        this.handlerService.executeHandler(command);
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        if (selectionProvider == oldSelectionProvider) {
            return;
        }
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        }
        this.selectionProvider = selectionProvider;
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        }
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)(selectionProvider == null ? null : selectionProvider.getSelection()));
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        if (this.selectionService != null) {
            this.selectionService.setSelection((Object)event.getSelection());
        }
    }

    private void disableUnwantedCommands() {
        if (this.handlerService == null || this.application == null) {
            return;
        }
        for (MCommand command : this.application.getCommands()) {
            String commandId = command.getElementId();
            if (this.availableCommandIds.contains(commandId)) continue;
            this.handlerService.activateHandler(commandId, (Object)new DisabledHandler(this.findElementUpdater(commandId)));
        }
    }

    private IElementUpdater findElementUpdater(String commandId) {
        if ("org.eclipse.ui.file.export".equals(commandId)) {
            return new WizardHandler.Export();
        }
        if ("org.eclipse.ui.file.import".equals(commandId)) {
            return new WizardHandler.Import();
        }
        return null;
    }

    @PreDestroy
    public void preDestroy() {
        this.content = null;
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
            this.tabFolder = null;
        }
    }

    public void hideDashboard() {
        MWindow window = DashboardPart.findWindowFor((MUIElement)this.partModel);
        if (window == null) {
            CathyPlugin.log("Failed to find window for Dashboard part.");
            return;
        }
        if (window.getTags().contains("CathyShowDashboard")) {
            window.getTags().remove("CathyShowDashboard");
        }
    }

    private static MWindow findWindowFor(MUIElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof MWindow) {
            return (MWindow)element;
        }
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder != null) {
            return DashboardPart.findWindowFor((MUIElement)placeholder);
        }
        return DashboardPart.findWindowFor((MUIElement)element.getParent());
    }

    @Inject
    @Optional
    public void subscribeDashboardTransientData(@EventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/transientData/*") org.osgi.service.event.Event event) {
        if (this.partModel == null || this.partModel != event.getProperty("ChangedElement")) {
            return;
        }
        Object selectedPageId = this.partModel.getTransientData().get("org.xmind.ui.part.dashboard.selectedPageId");
        if (selectedPageId == null || !(selectedPageId instanceof String)) {
            return;
        }
        if (this.tabFolder == null || this.content == null) {
            return;
        }
        MTabItem item = this.content.getItemById((String)selectedPageId);
        IDashboardPage dashboardPage = this.content.getDashboardPage(item);
        if (dashboardPage != null) {
            Control control = dashboardPage.getControl();
            if (control == null || control.isDisposed()) {
                dashboardPage.createControl(this.tabFolder.getBody());
                item.setControl(dashboardPage.getControl());
            }
            dashboardPage.setFocus();
            this.tabFolder.setSelection(item);
        }
    }

    @Focus
    public void setFocus() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && this.content != null) {
            MTabItem item = this.tabFolder.getSelection();
            if (item != null) {
                IDashboardPage page = this.content.getDashboardPage(item);
                if (page != null) {
                    page.setFocus();
                    return;
                }
                Control control = item.getControl();
                if (control != null) {
                    control.setFocus();
                    return;
                }
            }
            this.tabFolder.setFocus();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == MPart.class) {
            return adapter.cast(this.partModel);
        }
        if (this.context != null) {
            return (T)this.context.get(adapter);
        }
        return null;
    }

    public void registerAvailableCommandId(String commandId) {
        this.availableCommandIds.add(commandId);
    }

    public boolean registerContextMenu(Object menuParent, String menuId) {
        if (!(menuParent instanceof Control) || this.menuService == null || this.partModel == null) {
            return false;
        }
        Control parentControl = (Control)menuParent;
        MPopupMenu menuModel = null;
        for (MMenu item : this.partModel.getMenus()) {
            if (!menuId.equals(item.getElementId()) || !(item instanceof MPopupMenu)) continue;
            menuModel = (MPopupMenu)item;
            break;
        }
        if (menuModel == null) {
            menuModel = (MPopupMenu)this.modelService.createModelElement(MPopupMenu.class);
            menuModel.setElementId(menuId);
            menuModel.getTags().add("menuContribution:popup");
            this.partModel.getMenus().add(menuModel);
        }
        if (menuModel.getWidget() instanceof Menu) {
            Menu menu = (Menu)menuModel.getWidget();
            parentControl.setMenu(menu);
            return true;
        }
        return this.menuService.registerContextMenu((Object)parentControl, menuId);
    }

    public boolean openEditor(IEditorInput input, String editorId) {
        IWorkbenchPage page = (IWorkbenchPage)this.context.get(IWorkbenchPage.class);
        if (page == null) {
            return false;
        }
        try {
            page.openEditor(input, editorId);
            return true;
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.xmind.cathy", e.getMessage(), (Throwable)e), 2);
            return false;
        }
    }

    public boolean showView(String viewId) {
        IWorkbenchPage page = (IWorkbenchPage)this.context.get(IWorkbenchPage.class);
        if (page == null) {
            return false;
        }
        try {
            page.showView(viewId);
            return true;
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.xmind.cathy", e.getMessage(), (Throwable)e), 2);
            return false;
        }
    }

    public String getPersistedState(String key) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        return (String)this.partModel.getPersistedState().get(PERSISTED_STATE_KEY_PREFIX + key);
    }

    public void setPersistedState(String key, String value) {
        Assert.isLegal((key != null ? 1 : 0) != 0);
        if (value == null) {
            this.partModel.getPersistedState().remove(PERSISTED_STATE_KEY_PREFIX + key);
        } else {
            this.partModel.getPersistedState().put(PERSISTED_STATE_KEY_PREFIX + key, value);
        }
    }

    public <T> T getContextVariable(Class<T> key) {
        return (T)this.context.get(key);
    }

    public Object getContextVariable(String key) {
        return this.context.get(key);
    }
}

