/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.color;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.color.ColorAction;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorAction;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.color.PaletteViewer;

public class ColorPicker
extends ContributionItem
implements ISelectionProvider {
    public static final int NORMAL = 0;
    public static final int AUTO = 1;
    public static final int NONE = 2;
    public static final int CUSTOM = 4;
    public static int MODE_FORCE_TEXT = 1;
    private static boolean USE_COLOR_ICONS = true;
    private int mode = 0;
    private Widget widget;
    private IAction action;
    private int popupStyle;
    private PaletteContents palette;
    private ColorChooserPopupDialog popup;
    private IColorSelection selection;
    private RGB autoColor;
    private Listener toolItemListener;
    private Listener menuItemListener;
    private LocalResourceManager imageManager;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ColorPicker.this.actionPropertyChange(event);
        }
    };
    private final IPropertyChangeListener actionTextListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ColorPicker.this.update(event.getProperty());
        }
    };
    private List<ISelectionChangedListener> selectionChangedListeners = null;
    private List<IOpenListener> openListeners = null;
    private final ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (ColorPicker.this.selectionChangedDuringUpdate) {
                return;
            }
            if (ColorPicker.this.popup != null) {
                ColorPicker.this.popup.close();
            }
            ColorPicker.this.setSelection(event.getSelection());
        }
    };
    private final IOpenListener viewerOpenListener = new IOpenListener(){

        public void open(OpenEvent event) {
            if (ColorPicker.this.popup != null) {
                ColorPicker.this.popup.close();
            }
            ColorPicker.this.fireOpenEvent(event);
        }
    };
    private boolean selectionChangedDuringUpdate = false;

    public static boolean getUseColorIconsInToolbars() {
        return USE_COLOR_ICONS;
    }

    public static void setUseColorIconsInToolbars(boolean useColorIcons) {
        USE_COLOR_ICONS = useColorIcons;
    }

    public ColorPicker(PaletteContents palette) {
        this(0, palette, null, null, null);
    }

    public ColorPicker(int popupStyle, PaletteContents palette) {
        this(popupStyle, palette, null, null, null);
    }

    public ColorPicker(int popupStyle, PaletteContents palette, String text) {
        this(popupStyle, palette, text, null, null);
    }

    public ColorPicker(int popupStyle, PaletteContents palette, String text, ImageDescriptor image) {
        this(popupStyle, palette, text, image, null);
    }

    public ColorPicker(int popupStyle, PaletteContents palette, String text, ImageDescriptor image, String id) {
        super(id);
        this.action = image != null ? new Action(text, image){

            public void run() {
                super.run();
                ColorPicker.this.open();
            }
        } : new DropDownAction(text);
        this.popupStyle = popupStyle;
        this.palette = palette;
    }

    public ISelection getSelection() {
        return this.selection == null ? ColorSelection.EMPTY : this.selection;
    }

    public void setAutoColor(RGB color) {
        this.autoColor = color;
    }

    public void setSelection(ISelection selection) {
        if (selection == null || !(selection instanceof IColorSelection)) {
            selection = ColorSelection.EMPTY;
        }
        if (selection == this.selection || selection != null && selection.equals(this.selection)) {
            return;
        }
        this.selection = (IColorSelection)selection;
        this.update(null);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners == null) {
            this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        this.selectionChangedListeners.remove(listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        Object[] objectArray = this.selectionChangedListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((ISelectionChangedListener)l).selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpenEvent(final OpenEvent event) {
        if (this.openListeners == null) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(event);
                }
            });
            ++n2;
        }
    }

    private boolean hasPopupStyle(int style) {
        return (this.popupStyle & style) != 0;
    }

    public void open() {
        if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            ColorChooserPopupDialog dialog = this.getPopupDialog();
            if (dialog != null) {
                dialog.open(this.getItemBoundsToDisplay(item));
            }
        } else {
            ColorChooserPopupDialog dialog;
            Point curLoc = Display.getCurrent().getCursorLocation();
            if (curLoc != null && (dialog = this.getPopupDialog()) != null) {
                dialog.open(curLoc);
            }
        }
    }

    protected ColorChooserPopupDialog getPopupDialog() {
        Shell shell;
        if (this.popup == null && (shell = this.getShell()) != null) {
            this.popup = new ColorChooserPopupDialog(shell);
            this.popup.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ColorPicker.this.popup = null;
                }
            });
        }
        return this.popup;
    }

    private Shell getShell() {
        if (this.widget instanceof ToolItem) {
            return ((ToolItem)this.widget).getParent().getShell();
        }
        if (this.widget instanceof MenuItem) {
            return ((MenuItem)this.widget).getParent().getShell();
        }
        if (this.widget instanceof Control) {
            return ((Control)this.widget).getShell();
        }
        if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        return null;
    }

    private Rectangle getItemBoundsToDisplay(ToolItem item) {
        Rectangle bounds = item.getBounds();
        Point loc = item.getParent().toDisplay(bounds.x, bounds.y);
        bounds.x = loc.x;
        bounds.y = loc.y;
        return bounds;
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget == null && parent != null) {
            int flags = 131080;
            if (this.action != null) {
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4) {
                    flags = 4;
                }
            }
            ToolItem ti = null;
            ti = index >= 0 ? new ToolItem(parent, flags, index) : new ToolItem(parent, flags);
            ti.setData((Object)this);
            ti.addListener(13, this.getToolItemListener());
            ti.addListener(12, this.getToolItemListener());
            this.widget = ti;
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.addPropertyChangeListener(commandId, this.actionTextListener);
                }
            }
        }
    }

    public void fill(Menu parent, int index) {
        if (this.widget == null && parent != null) {
            Menu subMenu = null;
            int flags = 8;
            if (this.action != null) {
                IMenuCreator mc;
                int style = this.action.getStyle();
                if (style == 2) {
                    flags = 32;
                } else if (style == 8) {
                    flags = 16;
                } else if (style == 4 && (mc = this.action.getMenuCreator()) != null) {
                    subMenu = mc.getMenu(parent);
                    flags = 64;
                }
            }
            MenuItem mi = null;
            mi = index >= 0 ? new MenuItem(parent, flags, index) : new MenuItem(parent, flags);
            this.widget = mi;
            mi.setData((Object)this);
            mi.addListener(12, this.getMenuItemListener());
            mi.addListener(13, this.getMenuItemListener());
            if (this.action.getHelpListener() != null) {
                mi.addHelpListener(this.action.getHelpListener());
            }
            if (subMenu != null) {
                mi.setMenu(subMenu);
            }
            this.update(null);
            this.action.addPropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.addPropertyChangeListener(commandId, this.actionTextListener);
                }
            }
        }
    }

    private Listener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ColorPicker.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ColorPicker.this.handleWidgetSelection(event, ((MenuItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private Listener getToolItemListener() {
        if (this.toolItemListener == null) {
            this.toolItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            ColorPicker.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            Widget ew = event.widget;
                            if (ew == null) break;
                            ColorPicker.this.handleWidgetSelection(event, ((ToolItem)ew).getSelection());
                        }
                    }
                }
            };
        }
        return this.toolItemListener;
    }

    private void actionPropertyChange(final PropertyChangeEvent e) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(e.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ColorPicker.this.update(e.getProperty());
                    }
                });
            }
        }
    }

    public IAction getAction() {
        return this.action;
    }

    public int getMode() {
        return this.mode;
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    private boolean hasImages(IAction actionToCheck) {
        return actionToCheck.getImageDescriptor() != null || actionToCheck.getHoverImageDescriptor() != null || actionToCheck.getDisabledImageDescriptor() != null;
    }

    public boolean isDynamic() {
        if (this.widget instanceof MenuItem) {
            boolean actionIsRadio;
            boolean itemIsCheck = (this.widget.getStyle() & 0x20) != 0;
            boolean actionIsCheck = this.getAction() != null && this.getAction().getStyle() == 2;
            boolean itemIsRadio = (this.widget.getStyle() & 0x10) != 0;
            boolean bl = actionIsRadio = this.getAction() != null && this.getAction().getStyle() == 8;
            return itemIsCheck != actionIsCheck || itemIsRadio != actionIsRadio;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.action != null && this.action.isEnabled();
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.update();
    }

    private void handleWidgetDispose(Event e) {
        if (e.widget == this.widget) {
            IMenuCreator mc;
            if (this.action.getStyle() == 4 && (mc = this.action.getMenuCreator()) != null) {
                mc.dispose();
            }
            this.action.removePropertyChangeListener(this.propertyListener);
            if (this.action != null) {
                String commandId = this.action.getActionDefinitionId();
                ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                if (callback != null && commandId != null) {
                    callback.removePropertyChangeListener(commandId, this.actionTextListener);
                }
            }
            this.widget = null;
            this.disposeOldImages();
        }
    }

    private void handleWidgetSelection(Event e, boolean selection) {
        Widget item = e.widget;
        if (item != null) {
            int style = item.getStyle();
            if ((style & 0x22) != 0) {
                if (this.action.getStyle() == 2) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 0x10) != 0) {
                if (this.action.getStyle() == 8) {
                    this.action.setChecked(selection);
                }
            } else if ((style & 4) != 0 && e.detail == 4) {
                this.action.getStyle();
            }
            if (this.action.isEnabled()) {
                boolean trace = Policy.TRACE_ACTIONS;
                long ms = System.currentTimeMillis();
                if (trace) {
                    System.out.println("Running action: " + this.action.getText());
                }
                this.action.runWithEvent(e);
                if (trace) {
                    System.out.println(String.valueOf(System.currentTimeMillis() - ms) + " ms to run action: " + this.action.getText());
                }
            }
        }
    }

    public final void update() {
        this.update(null);
    }

    public void update(String propertyName) {
        if (this.widget != null) {
            boolean colorChanged;
            boolean textChanged = propertyName == null || propertyName.equals("text");
            boolean imageChanged = propertyName == null || propertyName.equals("image");
            boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
            boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
            boolean checkChanged = !(this.action.getStyle() != 2 && this.action.getStyle() != 8 || propertyName != null && !propertyName.equals("checked"));
            boolean bl = colorChanged = propertyName == null || propertyName.equals("color");
            if (this.widget instanceof ToolItem) {
                boolean showText;
                ToolItem ti = (ToolItem)this.widget;
                String text = this.action.getText();
                boolean bl2 = showText = text != null && ((this.getMode() & MODE_FORCE_TEXT) != 0 || !this.hasImages(this.action));
                if (showText && text != null) {
                    text = Action.removeAcceleratorText((String)text);
                    text = Action.removeMnemonics((String)text);
                }
                if (textChanged) {
                    boolean rightStyle;
                    String textToSet = showText ? text : "";
                    boolean bl3 = rightStyle = (ti.getParent().getStyle() & 0x20000) != 0;
                    if (rightStyle || !ti.getText().equals(textToSet)) {
                        ti.setText(textToSet);
                    }
                }
                if (imageChanged) {
                    this.updateImages(!showText);
                }
                if (tooltipTextChanged || textChanged) {
                    String toolTip = this.action.getToolTipText();
                    if (toolTip == null || toolTip.length() == 0) {
                        toolTip = text;
                    }
                    if (!showText || toolTip != null) {
                        ti.setToolTipText(toolTip);
                    } else {
                        ti.setToolTipText(null);
                    }
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled = this.action.isEnabled();
                    if (ti.getEnabled() != shouldBeEnabled) {
                        ti.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (ti.getSelection() != bv) {
                        ti.setSelection(bv);
                    }
                }
                if (colorChanged) {
                    this.updateColors();
                }
                return;
            }
            if (this.widget instanceof MenuItem) {
                MenuItem mi = (MenuItem)this.widget;
                if (textChanged) {
                    int accelerator = 0;
                    String acceleratorText = null;
                    IAction updatedAction = this.getAction();
                    String text = null;
                    accelerator = updatedAction.getAccelerator();
                    ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
                    if (accelerator != 0 && callback != null && callback.isAcceleratorInUse(accelerator)) {
                        accelerator = 0;
                    }
                    String commandId = updatedAction.getActionDefinitionId();
                    if ("gtk".equals(SWT.getPlatform()) && callback instanceof ExternalActionManager.IBindingManagerCallback && commandId != null) {
                        ExternalActionManager.IBindingManagerCallback bindingManagerCallback = (ExternalActionManager.IBindingManagerCallback)callback;
                        IKeyLookup lookup = KeyLookupFactory.getDefault();
                        TriggerSequence[] triggerSequences = bindingManagerCallback.getActiveBindingsFor(commandId);
                        int i = 0;
                        while (i < triggerSequences.length) {
                            Trigger trigger;
                            TriggerSequence triggerSequence = triggerSequences[i];
                            Trigger[] triggers = triggerSequence.getTriggers();
                            if (triggers.length == 1 && (trigger = triggers[0]) instanceof KeyStroke) {
                                KeyStroke currentKeyStroke = (KeyStroke)trigger;
                                int currentNaturalKey = currentKeyStroke.getNaturalKey();
                                if (currentKeyStroke.getModifierKeys() == (lookup.getCtrl() | lookup.getShift()) && (currentNaturalKey >= 48 && currentNaturalKey <= 57 || currentNaturalKey >= 65 && currentNaturalKey <= 70 || currentNaturalKey == 85)) {
                                    accelerator = currentKeyStroke.getModifierKeys() | currentNaturalKey;
                                    acceleratorText = triggerSequence.format();
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                    if (accelerator == 0) {
                        if (callback != null && commandId != null) {
                            acceleratorText = callback.getAcceleratorText(commandId);
                        }
                    } else {
                        acceleratorText = Action.convertAccelerator((int)accelerator);
                    }
                    IContributionManagerOverrides overrides = null;
                    if (this.getParent() != null) {
                        overrides = this.getParent().getOverrides();
                    }
                    if (overrides != null) {
                        text = this.getParent().getOverrides().getText((IContributionItem)this);
                    }
                    mi.setAccelerator(accelerator);
                    if (text == null) {
                        text = updatedAction.getText();
                    }
                    text = text == null ? "" : Action.removeAcceleratorText((String)text);
                    if (acceleratorText == null) {
                        mi.setText(text);
                    } else {
                        mi.setText(String.valueOf(text) + '\t' + acceleratorText);
                    }
                }
                if (imageChanged) {
                    this.updateImages(false);
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled = this.action.isEnabled();
                    if (mi.getEnabled() != shouldBeEnabled) {
                        mi.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (mi.getSelection() != bv) {
                        mi.setSelection(bv);
                    }
                }
                if (colorChanged) {
                    this.updateColors();
                }
                return;
            }
            if (this.widget instanceof Button) {
                Button button = (Button)this.widget;
                if (imageChanged && this.updateImages(false)) {
                    textChanged = false;
                }
                if (textChanged) {
                    String text = this.action.getText();
                    text = text == null ? "" : Action.removeAcceleratorText((String)text);
                    button.setText(text);
                }
                if (tooltipTextChanged) {
                    button.setToolTipText(this.action.getToolTipText());
                }
                if (enableStateChanged) {
                    boolean shouldBeEnabled = this.action.isEnabled();
                    if (button.getEnabled() != shouldBeEnabled) {
                        button.setEnabled(shouldBeEnabled);
                    }
                }
                if (checkChanged) {
                    boolean bv = this.action.isChecked();
                    if (button.getSelection() != bv) {
                        button.setSelection(bv);
                    }
                }
                if (colorChanged) {
                    this.updateColors();
                }
                return;
            }
        }
    }

    private void updateColors() {
        if (this.selection != null) {
            RGB c = this.selection.getColor();
            if (this.action instanceof IColorAction) {
                ((IColorAction)this.action).setColor(c);
            }
        }
    }

    private boolean updateImages(boolean forceImage) {
        ResourceManager parentResourceManager = JFaceResources.getResources();
        if (this.widget instanceof ToolItem) {
            if (USE_COLOR_ICONS) {
                ImageDescriptor image = this.action.getHoverImageDescriptor();
                if (image == null) {
                    image = this.action.getImageDescriptor();
                }
                ImageDescriptor disabledImage = this.action.getDisabledImageDescriptor();
                if (image == null && forceImage) {
                    image = ImageDescriptor.getMissingImageDescriptor();
                }
                LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
                ((ToolItem)this.widget).setDisabledImage(disabledImage == null ? null : localManager.createImageWithDefault(disabledImage));
                ((ToolItem)this.widget).setImage(image == null ? null : localManager.createImageWithDefault(image));
                this.disposeOldImages();
                this.imageManager = localManager;
                return image != null;
            }
            ImageDescriptor image = this.action.getImageDescriptor();
            ImageDescriptor hoverImage = this.action.getHoverImageDescriptor();
            ImageDescriptor disabledImage = this.action.getDisabledImageDescriptor();
            if (image == null && hoverImage != null) {
                image = ImageDescriptor.createWithFlags((ImageDescriptor)this.action.getHoverImageDescriptor(), (int)2);
            } else if (hoverImage == null && image != null) {
                hoverImage = image;
                image = ImageDescriptor.createWithFlags((ImageDescriptor)this.action.getImageDescriptor(), (int)2);
            }
            if (hoverImage == null && image == null && forceImage) {
                image = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
            ((ToolItem)this.widget).setDisabledImage(disabledImage == null ? null : localManager.createImageWithDefault(disabledImage));
            ((ToolItem)this.widget).setHotImage(hoverImage == null ? null : localManager.createImageWithDefault(hoverImage));
            ((ToolItem)this.widget).setImage(image == null ? null : localManager.createImageWithDefault(image));
            this.disposeOldImages();
            this.imageManager = localManager;
            return image != null;
        }
        if (this.widget instanceof Item || this.widget instanceof Button) {
            ImageDescriptor image = this.action.getHoverImageDescriptor();
            if (image == null) {
                image = this.action.getImageDescriptor();
            }
            if (image == null && forceImage) {
                image = ImageDescriptor.getMissingImageDescriptor();
            }
            LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
            if (this.widget instanceof Item) {
                ((Item)this.widget).setImage(image == null ? null : localManager.createImageWithDefault(image));
            } else if (this.widget instanceof Button) {
                ((Button)this.widget).setImage(image == null ? null : localManager.createImageWithDefault(image));
            }
            this.disposeOldImages();
            this.imageManager = localManager;
            return image != null;
        }
        return false;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    private final class ColorChooserPopupDialog
    extends PopupDialog {
        private Rectangle aroundBounds;
        private PaletteViewer viewer;
        private boolean showingNativeColorDialog;

        public ColorChooserPopupDialog(Shell parent) {
            super(parent, 8, true, false, false, false, false, null, null);
            this.aroundBounds = null;
            this.showingNativeColorDialog = false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayoutFactory layout = GridLayoutFactory.fillDefaults().spacing(0, 0);
            GridDataFactory layoutData = GridDataFactory.fillDefaults().grab(true, false);
            layout.copy().margins(4, 4).applyTo(composite);
            if (this.viewer == null) {
                this.viewer = new PaletteViewer(){

                    @Override
                    protected RGB openNativeColorDialog(Shell shell, RGB oldColor) {
                        ColorChooserPopupDialog.this.showingNativeColorDialog = true;
                        try {
                            RGB rGB = super.openNativeColorDialog(shell, oldColor);
                            return rGB;
                        }
                        finally {
                            ColorChooserPopupDialog.this.showingNativeColorDialog = false;
                        }
                    }
                };
                this.viewer.setShowAutoItem(ColorPicker.this.hasPopupStyle(1));
                this.viewer.setShowNoneItem(ColorPicker.this.hasPopupStyle(2));
                this.viewer.setShowCustomItem(ColorPicker.this.hasPopupStyle(4));
                this.viewer.addSelectionChangedListener(ColorPicker.this.viewerSelectionChangedListener);
                this.viewer.addOpenListener(ColorPicker.this.viewerOpenListener);
            }
            this.viewer.createControl(composite);
            layoutData.applyTo(this.viewer.getControl());
            this.viewer.setAutoColor(ColorPicker.this.autoColor);
            this.viewer.setInput(ColorPicker.this.palette);
            ColorPicker.this.selectionChangedDuringUpdate = true;
            this.viewer.setSelection(ColorPicker.this.selection);
            ColorPicker.this.selectionChangedDuringUpdate = false;
            return composite;
        }

        public int open(Rectangle aroundBounds) {
            this.aroundBounds = aroundBounds;
            return super.open();
        }

        public int open(Point location) {
            if (location != null) {
                this.aroundBounds = new Rectangle(location.x, location.y, 1, 1);
            }
            return super.open();
        }

        private Point calcLocation(Rectangle aroundBounds, Point shellSize) {
            Point loc = new Point(aroundBounds.x, aroundBounds.y);
            Rectangle area = this.getShell().getDisplay().getClientArea();
            if (aroundBounds.x + shellSize.x > area.x + area.width) {
                loc.x = aroundBounds.x + aroundBounds.width - shellSize.x;
            }
            loc.y = aroundBounds.y + aroundBounds.height + shellSize.y > area.y + area.height ? aroundBounds.y - shellSize.y : aroundBounds.y + aroundBounds.height;
            return loc;
        }

        protected Point getInitialLocation(Point initialSize) {
            if (this.aroundBounds != null) {
                return this.calcLocation(this.aroundBounds, initialSize);
            }
            return super.getInitialLocation(initialSize);
        }

        public boolean close() {
            Shell parentShell = null;
            if (this.getShell() != null && !this.getShell().isDisposed() && this.getShell().getParent() instanceof Shell) {
                parentShell = (Shell)this.getShell().getParent();
            }
            if (this.showingNativeColorDialog) {
                return false;
            }
            boolean closed = super.close();
            this.aroundBounds = null;
            if (ColorPicker.this.action != null) {
                ColorPicker.this.action.setChecked(false);
            }
            if (parentShell != null && !parentShell.isDisposed()) {
                Shell activeShell = Display.getCurrent().getActiveShell();
                if (parentShell.getData() instanceof PopupDialog && parentShell != activeShell) {
                    ((PopupDialog)parentShell.getData()).close();
                }
            }
            return closed;
        }

        protected Color getBackground() {
            return Display.getCurrent().getSystemColor(1);
        }
    }

    private final class DropDownAction
    extends ColorAction {
        private DropDownAction(String text) {
            super(null, 2);
            this.setText(text);
        }

        public void run() {
            super.run();
            ColorPicker.this.open();
        }
    }
}

