/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.zen;

import org.json.JSONObject;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;

public class ManifestDeserializer {
    public void deserialize(IManifest manifest, JSONObject manifestObject) {
        String passwordHint;
        JSONObject entriesObject = manifestObject.optJSONObject("file-entries");
        if (entriesObject != null) {
            for (String path : entriesObject.keySet()) {
                JSONObject encryptionDataObject;
                IFileEntry fileEntry = manifest.createFileEntry(path);
                JSONObject pathObject = entriesObject.optJSONObject(path);
                if (pathObject == null || (encryptionDataObject = pathObject.optJSONObject("encryption-data")) == null) continue;
                this.deserializeEncryptionData(fileEntry, encryptionDataObject);
            }
        }
        if ((passwordHint = (String)manifestObject.opt("password-hint")) != null) {
            manifest.setPasswordHint(passwordHint);
        }
    }

    private void deserializeEncryptionData(IFileEntry fileEntry, JSONObject encryptionDataObject) {
        int iterationCount = encryptionDataObject.optInt("iteration-count");
        String algorithmName = encryptionDataObject.optString("algorithm-name");
        String derivationName = encryptionDataObject.optString("key-derivation-name");
        int size = encryptionDataObject.optInt("size");
        String salt = encryptionDataObject.optString("salt");
        String iv = encryptionDataObject.optString("iv");
        IEncryptionData encryptionData = fileEntry.createEncryptionData();
        encryptionData.setAttribute("" + iterationCount, new String[]{"key-derivation", "iteration-count"});
        encryptionData.setAttribute(algorithmName, new String[]{"algorithm", "algorithm-name"});
        encryptionData.setAttribute(derivationName, new String[]{"key-derivation", "key-derivation-name"});
        encryptionData.setAttribute("" + size, new String[]{"key-derivation", "size"});
        encryptionData.setAttribute(salt, new String[]{"key-derivation", "salt"});
        encryptionData.setAttribute(iv, new String[]{"key-derivation", "iv"});
    }
}

