/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.gef.ui.properties.PropertySectionPart;
import org.xmind.ui.internal.properties.PropertySectionContributorManager;
import org.xmind.ui.util.Logger;

public class PropertySectionFactory {
    private IConfigurationElement element;
    private String id;
    private Expression enablementExpression;
    private String preferredTitle;

    PropertySectionFactory(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        this.preferredTitle = element.getAttribute("name");
        if (PropertySectionContributorManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
        this.initializeEnablement();
    }

    private void initializeEnablement() {
        IConfigurationElement[] enabledWhens = this.element.getChildren("enabledWhen");
        if (enabledWhens.length == 0) {
            return;
        }
        IConfigurationElement[] enablements = enabledWhens[0].getChildren();
        if (enablements.length == 0) {
            return;
        }
        try {
            this.enablementExpression = ExpressionConverter.getDefault().perform(enablements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert expression: " + this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isApplicableTo(Object object) {
        if (this.enablementExpression == null) {
            return true;
        }
        try {
            EvaluationResult result = this.enablementExpression.evaluate((IEvaluationContext)new EvaluationContext(null, object));
            return result == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed on: " + this.id);
            return false;
        }
    }

    public boolean isEnabledOn(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!this.isApplicableTo(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IPropertySectionPart createSection() {
        try {
            IPropertySectionPart section = (IPropertySectionPart)this.element.createExecutableExtension("class");
            if (section.getTitle() == null && section instanceof PropertySectionPart) {
                ((PropertySectionPart)section).setTitle(this.preferredTitle);
            }
            return section;
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to create property section: " + this.id);
            return null;
        }
    }
}

