/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.UIPlugin;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.notes.NotesHyperlinkDetector;
import org.xmind.ui.internal.notes.NotesTextViewer;
import org.xmind.ui.internal.notes.NotesUtils;
import org.xmind.ui.internal.notes.RichDocumentNotesAdapter;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextActionBarContributor;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.RichTextActionBarContributor;
import org.xmind.ui.richtext.RichTextDamagerRepairer;
import org.xmind.ui.richtext.RichTextRenderer;
import org.xmind.ui.richtext.RichTextScanner;
import org.xmind.ui.richtext.RichTextViewerUndoManager;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.util.TextFormatter;

public class NotesTextEditViewer
implements IRichTextEditViewer,
KeyListener {
    public static final int WIDTH = 4;
    private IRichDocument document;
    private Composite control;
    private NotesTextViewer textViewer;
    private NotesTextViewer oldTextViewer;
    private boolean editable;
    private IRichTextRenderer renderer;
    private IRichTextActionBarContributor contributor;
    private ToolBarManager toolBarManager = null;
    private MenuManager contextMenu = null;
    private ScrolledComposite sc;
    private Composite contentComposite;
    private Composite composite;
    private Object input;
    private List<Composite> textComposites = new ArrayList<Composite>();
    private List<Control> textControls = new ArrayList<Control>();
    private Map<Composite, ITopic> maps = new HashMap<Composite, ITopic>();
    private Composite currentTextComposite;
    private ISelectionProvider selectionProvider;
    private IGraphicalEditor editor;
    private int width = 0;
    private ResourceManager resources;

    public NotesTextEditViewer(Composite parent, IRichTextActionBarContributor contributor) {
        this.contributor = contributor;
        this.control = this.createControl(parent);
    }

    protected Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createContentArea(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NotesTextEditViewer.this.handleControlDispose(e);
            }
        });
        return composite;
    }

    protected void createContentArea(Composite parent) {
        Control toolBar = this.createToolBar(parent);
        if (toolBar != null) {
            this.createSeparator(parent);
        }
        this.composite = this.createContentComposite(parent);
    }

    protected Control createToolBar(Composite parent) {
        if (this.contributor == null) {
            return null;
        }
        this.contributor.init((IRichTextEditViewer)this);
        this.toolBarManager = new ToolBarManager(0x800000);
        this.contributor.fillToolBar((IToolBarManager)this.toolBarManager);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                NotesTextEditViewer.this.toolBarManager.update(true);
            }
        });
        ToolBar toolBar = this.toolBarManager.createControl(parent);
        toolBar.setBackground(parent.getDisplay().getSystemColor(22));
        toolBar.setLayoutData((Object)new GridData(768));
        return toolBar;
    }

    protected void createSeparator(Composite parent) {
        Label sep = new Label(parent, 258);
        sep.setLayoutData((Object)new GridData(768));
        sep.setBackground(parent.getDisplay().getSystemColor(22));
    }

    private Composite createContentComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(parent.getBackground());
        return composite;
    }

    protected NotesTextViewer createTextViewer(Composite parent, int style) {
        return new NotesTextViewer(parent, style);
    }

    protected RichTextRenderer createRenderer(TextViewer textViewer) {
        return new RichTextRenderer(textViewer);
    }

    private void initTextViewer(TextViewer textViewer) {
        StyledText control = textViewer.getTextWidget();
        this.createContentPopupMenu((Control)control);
        textViewer.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        textViewer.setUndoManager((IUndoManager)new RichTextViewerUndoManager(25));
        textViewer.activatePlugins();
        this.addHyperlinkListener(textViewer);
    }

    private void createContentPopupMenu(Control control) {
        this.contextMenu = new MenuManager();
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NotesTextEditViewer.this.fillContextMenu(manager);
            }
        });
        control.setMenu(this.contextMenu.createContextMenu(control));
    }

    private void fillContextMenu(IMenuManager menu) {
        if (this.contributor != null) {
            this.contributor.fillContextMenu(menu);
        }
    }

    private void addHyperlinkListener(TextViewer viewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        RichTextDamagerRepairer dr = new RichTextDamagerRepairer((ITokenScanner)new RichTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDocumentPartitioning("__dftl_partitioning");
        reconciler.install((ITextViewer)viewer);
    }

    protected void handleControlDispose(DisposeEvent e) {
        if (this.contributor != null) {
            this.contributor.dispose();
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager = null;
        }
        if (this.document != null) {
            this.unhookDocument(this.document);
            this.document = null;
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Control getFocusControl() {
        if (this.textViewer == null) {
            return null;
        }
        return this.textViewer.getControl();
    }

    public IRichDocument getDocument() {
        return this.document;
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    protected void hookDocument(IRichDocument document) {
    }

    protected void unhookDocument(IRichDocument document) {
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
    }

    public IRichTextActionBarContributor getContributor() {
        return this.contributor;
    }

    public void update() {
        Point origin = null;
        if (this.sc != null && !this.sc.isDisposed()) {
            origin = this.sc.getOrigin();
        }
        this.updateNotes();
        this.updateDeleteAction();
        if (this.sc != null && !this.sc.isDisposed() && origin != null) {
            this.sc.setOrigin(origin);
        }
    }

    public void setInput(Object input) {
        this.updateView(input);
    }

    private void updateView(Object input) {
        if (!(this.input instanceof IRichDocument) || !(input instanceof IRichDocument)) {
            this.input = input;
            if (input == null) {
                this.input = this.getCurrentSheet();
            }
            this.updateNotes();
            this.updateToolBar();
        }
    }

    private void updateNotes() {
        if (this.composite == null || this.composite.isDisposed()) {
            return;
        }
        this.composite.setRedraw(false);
        this.resetContent();
        if (this.input instanceof IRichDocument) {
            this.showSingleNotes(this.composite, null);
        } else if (this.input instanceof ISheet) {
            this.showAllNotes(this.composite);
        } else {
            this.toolBarManager.getControl().setEnabled(false);
        }
        this.composite.layout();
        this.composite.setRedraw(true);
    }

    private void resetContent() {
        Control[] controls = this.composite.getChildren();
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                    Object var2_5 = null;
                }
                ++n2;
            }
        }
        this.textComposites.clear();
        this.textControls.clear();
        this.maps.clear();
        this.toolBarManager.getControl().setEnabled(true);
        this.width = 0;
        this.setTextViewer(null);
        this.setSelection(null);
    }

    protected void showSingleNotes(Composite parent, ITopic topic) {
        this.textViewer = this.createTextViewer(parent, 578);
        this.initTextViewer(this.textViewer);
        this.renderer = this.createRenderer(this.textViewer);
        final Control text = this.textViewer.getControl();
        text.setBackground(parent.getBackground());
        text.setForeground(parent.getDisplay().getSystemColor(2));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 160;
        gridData.horizontalIndent = 2;
        gridData.verticalIndent = 2;
        text.setLayoutData((Object)gridData);
        RGB red = new RGB(183, 0, 91);
        this.textViewer.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(red));
        this.textViewer.setHyperlinkDetectors(new IHyperlinkDetector[]{new NotesHyperlinkDetector()}, SWT.MOD1);
        this.setTextViewer(this.textViewer);
        this.setSelection(this.textViewer);
        this.composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (text != null && !text.isDisposed()) {
                    ((GridData)text.getLayoutData()).widthHint = ((NotesTextEditViewer)NotesTextEditViewer.this).composite.getSize().x - 22;
                }
            }
        });
    }

    private void showAllNotes(Composite parent) {
        ISheet sheet = (ISheet)this.input;
        List<ITopic> topics = NotesUtils.getAllTopicsWithNotes(sheet);
        if (topics == null || topics.size() == 0) {
            return;
        }
        this.contentComposite = this.createTextControl(parent);
        for (ITopic topic : topics) {
            this.showLabelAndNote(this.contentComposite, topic);
        }
        if (this.sc.getClientArea().width > 0) {
            for (Control textControl : this.textControls) {
                ((GridData)textControl.getLayoutData()).widthHint = this.sc.getClientArea().width - 4;
            }
        }
        this.sc.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (((NotesTextEditViewer)NotesTextEditViewer.this).sc.getClientArea().width <= 0) {
                    return;
                }
                if (NotesTextEditViewer.this.width != ((NotesTextEditViewer)NotesTextEditViewer.this).sc.getClientArea().width) {
                    NotesTextEditViewer.this.width = ((NotesTextEditViewer)NotesTextEditViewer.this).sc.getClientArea().width;
                    for (Control textControl : NotesTextEditViewer.this.textControls) {
                        if (textControl == null || textControl.isDisposed()) continue;
                        ((GridData)textControl.getLayoutData()).widthHint = ((NotesTextEditViewer)NotesTextEditViewer.this).sc.getClientArea().width - 4;
                    }
                    NotesTextEditViewer.this.contentComposite.pack();
                }
            }
        });
    }

    protected Composite createTextControl(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        this.sc.setAlwaysShowScrollBars(true);
        this.sc.setLayoutData((Object)new GridData(1808));
        this.sc.setBackground(parent.getBackground());
        this.sc.setExpandHorizontal(true);
        this.sc.setMinSize(-1, -1);
        Composite composite = new Composite((Composite)this.sc, 0);
        composite.setBackground(parent.getBackground());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.sc.setContent((Control)composite);
        this.sc.getVerticalBar().setIncrement(17);
        return composite;
    }

    private void showLabelAndNote(Composite parent, ITopic topic) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createTopicLabel(composite, topic);
        this.createSingleNotes(composite, topic);
        this.createSeparatorLine(parent);
    }

    private void createTopicLabel(Composite parent, ITopic topic) {
        Composite c = new Composite(parent, 0);
        c.setBackground(parent.getBackground());
        c.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        c.setLayout((Layout)layout);
        Label imageLabel = new Label(c, 16384);
        GridData data1 = new GridData(16384, 0x1000000, false, false);
        imageLabel.setLayoutData((Object)data1);
        imageLabel.setBackground(c.getBackground());
        Image image = (Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().getTopicIcon(topic, true));
        imageLabel.setImage(image);
        Label label = new Label(c, 16640);
        label.setBackground(parent.getBackground());
        label.setForeground(ColorConstants.black);
        GridData data = new GridData(1808);
        data.horizontalIndent = 2;
        label.setLayoutData((Object)data);
        FontData[] fontData = label.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontData[i].getHeight() + 2);
            ++i;
        }
        final Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        label.setText(String.valueOf(TextFormatter.removeNewLineCharacter((String)topic.getTitleText())) + ":");
    }

    private void createSingleNotes(Composite parent, ITopic topic) {
        final Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        composite.setLayout((Layout)layout);
        this.textComposites.add(composite);
        this.maps.put(composite, topic);
        this.createContentText(composite, topic);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (composite == null || composite.isDisposed()) {
                    return;
                }
                if (!composite.isFocusControl()) {
                    composite.forceFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                NotesTextEditViewer.this.reveal(composite);
            }
        };
        this.addMosuseListener((Control)composite, (MouseListener)ml);
        composite.addFocusListener(new FocusListener(){
            private Color originalBgColor = null;

            public void focusLost(FocusEvent e) {
                composite.setBackground(this.originalBgColor);
                composite.removeKeyListener((KeyListener)NotesTextEditViewer.this);
                NotesTextEditViewer.this.currentTextComposite = null;
                NotesTextEditViewer.this.updateDeleteAction();
            }

            public void focusGained(FocusEvent e) {
                this.originalBgColor = composite.getBackground();
                composite.setBackground(ColorConstants.lightBlue);
                NotesTextEditViewer.this.currentTextComposite = composite;
                composite.addKeyListener((KeyListener)NotesTextEditViewer.this);
                NotesTextEditViewer.this.sc.showControl((Control)composite.getParent());
                NotesTextEditViewer.this.updateDeleteAction();
            }
        });
    }

    protected void updateDeleteAction() {
        if (this.contributor == null) {
            return;
        }
        IRichTextAction deleteNotesAction = ((RichTextActionBarContributor)this.contributor).getRichTextAction("org.xmind.ui.action.deleteNotes");
        deleteNotesAction.setEnabled(this.currentTextComposite != null);
    }

    private Control createContentText(Composite parent, ITopic topic) {
        Text text = new Text(parent, 74);
        text.setBackground(parent.getBackground());
        text.setForeground(ColorConstants.black);
        text.setLayoutData((Object)new GridData(1808));
        RichDocumentNotesAdapter adapter = new RichDocumentNotesAdapter(topic);
        text.setText(adapter.getDocument().get());
        this.textControls.add((Control)text);
        return text;
    }

    private void createSeparatorLine(Composite parent) {
        Label sep = new Label(parent, 258);
        sep.setLayoutData((Object)new GridData(768));
        sep.setBackground(ColorConstants.black);
    }

    private void reveal(Composite composite) {
        MindMapUtils.reveal(this.editor, this.getCurrentTopic(composite));
        E4Utils.showPart("org.xmind.ui.command.showModelPart", PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.modelPart.notes", null, "org.xmind.ui.stack.right");
    }

    private void addMosuseListener(Control c, MouseListener ml) {
        c.addMouseListener(ml);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                this.addMosuseListener(cc, ml);
                ++n2;
            }
        }
    }

    public void updateToolBar() {
        if (this.toolBarManager == null) {
            return;
        }
        if (this.contributor != null) {
            this.contributor.selectionChanged(this.getSelection(), true);
        }
        this.toolBarManager.update(false);
    }

    public void setDocument(IRichDocument document) {
        IRichDocument oldDocument = this.document;
        this.document = document;
        this.documentChanged(document, oldDocument);
        this.textViewer.setDocument((IDocument)(document == null ? new Document() : document));
        if (document != null) {
            this.textViewer.setSelectedRange(document.getLength(), 0);
        }
    }

    protected void documentChanged(IRichDocument newDocument, IRichDocument oldDocument) {
        if (newDocument != oldDocument) {
            if (oldDocument != null) {
                this.unhookDocument(oldDocument);
            }
            if (newDocument != null) {
                this.hookDocument(newDocument);
            }
        }
    }

    public IRichTextRenderer getRenderer() {
        return this.renderer;
    }

    public Point getSelectedRange() {
        return this.textViewer.getSelectedRange();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.textViewer.setSelection(selection, reveal);
    }

    public void setSelectedRange(int selectionOffset, int selectionLength) {
        this.textViewer.setSelectedRange(selectionOffset, selectionLength);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.textViewer != null) {
            this.textViewer.addPostSelectionChangedListener(listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.textViewer.removePostSelectionChangedListener(listener);
    }

    public void addTextInputListener(ITextInputListener listener) {
        this.textViewer.addTextInputListener(listener);
    }

    public void addTextListener(ITextListener listener) {
        this.textViewer.addTextListener(listener);
    }

    public void removeTextInputListener(ITextInputListener listener) {
        this.textViewer.removeTextInputListener(listener);
    }

    public void removeTextListener(ITextListener listener) {
        this.textViewer.removeTextListener(listener);
    }

    public boolean isSelectedRangeEmpty() {
        Point p = this.getSelectedRange();
        return p.y <= 0;
    }

    public StyledText getTextWidget() {
        return this.textViewer.getTextWidget();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (editable == this.editable) {
            return;
        }
        this.editable = editable;
    }

    public void keyPressed(KeyEvent e) {
        IRichTextAction action;
        if (e.keyCode == 0x1000002) {
            this.moveDown();
        } else if (e.keyCode == 0x1000001) {
            this.moveUp();
        } else if (e.keyCode == 13) {
            this.reveal(this.currentTextComposite);
        } else if (e.keyCode == 127 && (action = ((RichTextActionBarContributor)this.contributor).getRichTextAction("org.xmind.ui.action.deleteNotes")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void moveDown() {
        if (this.currentTextComposite == null) {
            return;
        }
        int index = this.textComposites.indexOf(this.currentTextComposite);
        if (index < 0 || index >= this.textComposites.size() - 1) {
            return;
        }
        this.textComposites.get(index + 1).forceFocus();
    }

    private void moveUp() {
        if (this.currentTextComposite == null) {
            return;
        }
        int index = this.textComposites.indexOf(this.currentTextComposite);
        if (index <= 0 || index > this.textComposites.size() - 1) {
            return;
        }
        this.textComposites.get(index - 1).forceFocus();
    }

    public Composite getCurrentTextComposite() {
        return this.currentTextComposite;
    }

    public void setCurrentTextComposite(Composite currentTextComposite) {
        this.currentTextComposite = currentTextComposite;
    }

    public ITopic getCurrentTopic(Composite currentComposite) {
        if (this.maps == null || this.maps.size() == 0) {
            return null;
        }
        return this.maps.get(currentComposite);
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new SelectionProvider();
        }
        return this.selectionProvider;
    }

    public void setSelection(ISelection selection) {
        this.getSelectionProvider().setSelection(selection);
    }

    public ISelection getSelection() {
        return this.getSelectionProvider().getSelection();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().removeSelectionChangedListener(listener);
    }

    private void setTextViewer(NotesTextViewer textViewer) {
        this.oldTextViewer = this.textViewer;
        this.textViewer = textViewer;
    }

    public NotesTextViewer getOldTextViewer() {
        return this.oldTextViewer;
    }

    public List<Control> getTextControls() {
        return this.textControls;
    }

    public IGraphicalEditor getEditor() {
        return this.editor;
    }

    public void setEditor(IGraphicalEditor editor) {
        this.editor = editor;
    }

    private ISheet getCurrentSheet() {
        IGraphicalEditor editor;
        IEditorPart activeEditor = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor && (editor = (IGraphicalEditor)activeEditor).getActivePageInstance() != null) {
            ISheet sheet = (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
            return sheet;
        }
        return null;
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> selectionChangedListeners = null;
        private ISelection selection;

        private SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
            }
            this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection == null ? StructuredSelection.EMPTY : this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (this.selection == selection || this.selection != null && this.selection.equals(selection)) {
                return;
            }
            this.selection = selection;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            Object[] objectArray = this.selectionChangedListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ISelectionChangedListener)o).selectionChanged(event);
                ++n2;
            }
        }
    }
}

