/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.CompositeFeedback;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IPointProvider;
import org.xmind.gef.service.IPositionProvider;
import org.xmind.gef.service.LineFeedback;
import org.xmind.gef.service.PointFeedback;
import org.xmind.ui.decorations.IRelationshipDecoration;
import org.xmind.ui.resources.ColorUtils;

public class RelationshipFeedback
extends CompositeFeedback {
    private IFigure figure;
    private IGraphicalPart part;
    private PointFeedback sourceAnchor;
    private PointFeedback targetAnchor;
    private PointFeedback sourceControlPoint;
    private PointFeedback targetControlPoint;
    private LineFeedback sourceLine;
    private LineFeedback targetLine;

    public RelationshipFeedback(IFigure figure) {
        this.figure = figure;
        this.init();
    }

    public RelationshipFeedback(IGraphicalPart part) {
        this.part = part;
        this.init();
    }

    private void init() {
        this.sourceAnchor = RelationshipFeedback.createAnchorPointFeedback();
        this.targetAnchor = RelationshipFeedback.createAnchorPointFeedback();
        this.sourceControlPoint = RelationshipFeedback.createControlPointFeedback();
        this.targetControlPoint = RelationshipFeedback.createControlPointFeedback();
        this.sourceLine = RelationshipFeedback.createLineFeedback();
        this.targetLine = RelationshipFeedback.createLineFeedback();
        this.sourceAnchor.setPositionProvider(new IPointProvider(){

            public Point getPoint() {
                return RelationshipFeedback.this.getAnchorPoint(true);
            }
        });
        this.targetAnchor.setPositionProvider(new IPointProvider(){

            public Point getPoint() {
                return RelationshipFeedback.this.getAnchorPoint(false);
            }
        });
        this.sourceControlPoint.setPositionProvider(new IPointProvider(){

            public Point getPoint() {
                return RelationshipFeedback.this.getControlPoint(true);
            }
        });
        this.targetControlPoint.setPositionProvider(new IPointProvider(){

            public Point getPoint() {
                return RelationshipFeedback.this.getControlPoint(false);
            }
        });
        this.sourceLine.setPositionProvider(new IPositionProvider(){

            public Point getTargetPosition() {
                return RelationshipFeedback.this.getAnchorPoint(true);
            }

            public Point getSourcePosition() {
                return RelationshipFeedback.this.getControlPoint(true);
            }
        });
        this.targetLine.setPositionProvider(new IPositionProvider(){

            public Point getTargetPosition() {
                return RelationshipFeedback.this.getAnchorPoint(false);
            }

            public Point getSourcePosition() {
                return RelationshipFeedback.this.getControlPoint(false);
            }
        });
        this.addFeedback((IFeedback)this.sourceLine);
        this.addFeedback((IFeedback)this.targetLine);
        this.addFeedback((IFeedback)this.sourceAnchor);
        this.addFeedback((IFeedback)this.targetAnchor);
        this.addFeedback((IFeedback)this.sourceControlPoint);
        this.addFeedback((IFeedback)this.targetControlPoint);
    }

    private Point getAnchorPoint(boolean sourceOrTarget) {
        IFigure fig = this.getFigure();
        if (fig != null) {
            return RelationshipFeedback.getAnchorPosition(sourceOrTarget, fig);
        }
        return null;
    }

    private Point getControlPoint(boolean sourceOrTarget) {
        IFigure fig = this.getFigure();
        if (fig != null) {
            return RelationshipFeedback.getControlPointPosition(sourceOrTarget, fig);
        }
        return null;
    }

    private static PointFeedback createAnchorPointFeedback() {
        PointFeedback feedback = new PointFeedback(2);
        feedback.setHeight(9);
        feedback.setFillColor(ColorUtils.getColor((String)"#e08000"));
        feedback.setBorderColor(ColorUtils.getColor((String)"#c04000"));
        return feedback;
    }

    private static PointFeedback createControlPointFeedback() {
        PointFeedback feedback = new PointFeedback(3);
        feedback.setHeight(11);
        feedback.setFillColor(ColorUtils.getColor((String)"#f0f000"));
        feedback.setBorderColor(ColorUtils.getColor((String)"#b0b0b0"));
        return feedback;
    }

    private static LineFeedback createLineFeedback() {
        LineFeedback feedback = new LineFeedback();
        feedback.setColor(ColorUtils.getColor((String)"#b0b0b0"));
        return feedback;
    }

    public int getPointId(Point p) {
        if (this.sourceAnchor.containsPoint(p)) {
            return 1;
        }
        if (this.targetAnchor.containsPoint(p)) {
            return 2;
        }
        if (this.sourceControlPoint.containsPoint(p)) {
            return 3;
        }
        if (this.targetControlPoint.containsPoint(p)) {
            return 4;
        }
        return 0;
    }

    private IFigure getFigure() {
        if (this.figure == null && this.part != null) {
            this.figure = this.part.getFigure();
        }
        return this.figure;
    }

    public void setAlpha(int alpha) {
        this.sourceAnchor.setAlpha(alpha);
        this.targetAnchor.setAlpha(alpha);
        this.sourceControlPoint.setAlpha(alpha);
        this.targetControlPoint.setAlpha(alpha);
        this.sourceLine.setAlpha(alpha);
        this.targetLine.setAlpha(alpha);
    }

    public static Point getAnchorPosition(boolean sourceOrTarget, IFigure figure) {
        IDecoration decoration;
        if (figure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof IConnectionDecoration) {
            IConnectionDecoration connection = (IConnectionDecoration)decoration;
            if (sourceOrTarget) {
                PrecisionPoint p = connection.getSourcePosition(figure);
                if (p != null) {
                    return p.toRoundedDraw2DPoint();
                }
            } else {
                PrecisionPoint p = connection.getTargetPosition(figure);
                if (p != null) {
                    return p.toRoundedDraw2DPoint();
                }
            }
        }
        return null;
    }

    public static Point getControlPointPosition(boolean sourceOrTarget, IFigure figure) {
        IDecoration decoration;
        if (figure instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)figure).getDecoration()) instanceof IRelationshipDecoration) {
            if (sourceOrTarget) {
                PrecisionPoint p = ((IRelationshipDecoration)decoration).getSourceControlPoint(figure);
                if (p != null) {
                    return p.toRoundedDraw2DPoint();
                }
            } else {
                PrecisionPoint p = ((IRelationshipDecoration)decoration).getTargetControlPoint(figure);
                if (p != null) {
                    return p.toRoundedDraw2DPoint();
                }
            }
        }
        return null;
    }
}

