/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.decorations.AbstractBranchConnection;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.internal.figures.BranchFigure;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;

public class TimelineHorizontalConnection
extends AbstractBranchConnection {
    private IBranchPart branch;

    public TimelineHorizontalConnection(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    protected void route(IFigure figure, org.xmind.gef.draw2d.graphics.Path shape) {
        Point sp = this.getPosition(this.branch.getTopicPart());
        List<IBranchPart> subBranches = this.branch.getSubBranches();
        Point tp = sp;
        if (subBranches != null && !subBranches.isEmpty()) {
            IBranchPart lastBranch = subBranches.get(subBranches.size() - 1);
            tp = this.getPosition(lastBranch.getTopicPart());
        }
        if (figure instanceof BranchFigure) {
            shape.moveTo(sp);
            shape.lineTo((float)tp.x, (float)sp.y);
        } else {
            shape.moveTo(this.getSourcePosition(figure));
            shape.lineTo(this.getTargetPosition(figure));
        }
    }

    private Point getPosition(ITopicPart topic) {
        Rectangle bounds = topic.getFigure().getBounds();
        return bounds.getLocation().getTranslated(bounds.width / 2, bounds.height / 2);
    }

    @Override
    protected void paintPath(IFigure figure, Graphics graphics, org.xmind.gef.draw2d.graphics.Path path, boolean fill) {
        if (this.branch != null) {
            Rectangle bounds = figure.getBounds();
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            shape.addRectangle(bounds);
            shape.addPath((Path)this.getDecoration(this.branch).createClippingPath(this.branch.getTopicPart().getFigure()));
            for (IBranchPart sub : this.branch.getSubBranches()) {
                shape.addPath((Path)this.getDecoration(sub).createClippingPath(sub.getTopicPart().getFigure()));
            }
            graphics.pushState();
            try {
                graphics.setClip((Path)shape);
                if (this.getLineWidth() > 0) {
                    graphics.drawPath((Path)path);
                }
                graphics.restoreState();
            }
            finally {
                graphics.popState();
                shape.close();
                shape.dispose();
            }
            return;
        }
        super.paintPath(figure, graphics, path, fill);
    }

    private ITopicDecoration getDecoration(IBranchPart branch) {
        IFigure figure = branch.getTopicPart().getFigure();
        return ((TopicFigure)figure).getDecoration();
    }
}

