/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.viewers.ISelection;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.RequestAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.util.MindMapUtils;

public class AlignmentRequestAction
extends RequestAction
implements ISelectionAction {
    private int alignment;

    public AlignmentRequestAction(IGraphicalEditorPage page, int alignment) {
        super(page, "align");
        this.alignment = alignment;
        switch (alignment) {
            case 1: {
                this.setId("org.xmind.ui.align_left");
                break;
            }
            case 2: {
                this.setId("org.xmind.ui.align_center");
                break;
            }
            case 4: {
                this.setId("org.xmind.ui.align_right");
                break;
            }
            case 8: {
                this.setId("org.xmind.ui.align_top");
                break;
            }
            case 16: {
                this.setId("org.xmind.ui.align_middle");
                break;
            }
            case 32: {
                this.setId("org.xmind.ui.align_bottom");
            }
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        Request request = new Request(this.getRequestType());
        request.setDomain(this.getEditDomain());
        request.setViewer((IViewer)this.getViewer());
        request.setParameter("alignment", (Object)this.getAlignment());
        this.sendRequest(request);
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.hasSuchElements(selection, "org.xmind.ui.topic") && !MindMapUtils.isSingleTopic(selection));
    }
}

