/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.signin;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xmind.ui.evernote.signin.IEvernoteAccount;
import org.xmind.ui.internal.evernote.signin.EvernoteAccount;

public class EvernoteAccountStore {
    public static final String TOKEN = "token";
    public static final String USERNAME = "username";
    public static final String SERVICE_TYPE = "serviceType";
    public static final String EVERNOTE_SIGNEDIN = "signedin";
    private IPreferenceStore localStore;
    private EvernoteAccount accountInfo;

    public EvernoteAccountStore(IPreferenceStore prefStore) {
        this.localStore = prefStore;
        this.readFromStore();
    }

    private void readFromStore() {
        String authToken = this.localStore.getString(TOKEN);
        String username = this.localStore.getString(USERNAME);
        String serviceType = this.localStore.getString(SERVICE_TYPE);
        if (!(authToken == null || "".equals(authToken) || username == null || "".equals(username) || serviceType == null || "".equals(serviceType))) {
            this.accountInfo = new EvernoteAccount(authToken, username, serviceType);
        }
    }

    public void signedIn(String authToken, String username, String serviceType) {
        this.accountInfo = new EvernoteAccount(authToken, username, serviceType);
        this.saveToStore(authToken, username, serviceType);
    }

    private void saveToStore(String authToken, String username, String serviceType) {
        this.localStore.setValue(TOKEN, authToken);
        this.localStore.setValue(USERNAME, username);
        this.localStore.setValue(SERVICE_TYPE, serviceType);
        this.localStore.setValue(EVERNOTE_SIGNEDIN, true);
        this.flushStore();
    }

    public void signedOut() {
        this.accountInfo = null;
        this.clearStore();
    }

    private void clearStore() {
        this.localStore.setValue(TOKEN, "");
        this.localStore.setValue(USERNAME, "");
        this.localStore.setValue(SERVICE_TYPE, "");
        this.localStore.setValue(EVERNOTE_SIGNEDIN, false);
        this.flushStore();
    }

    private void flushStore() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.xmind.ui.evernote");
        if (node != null) {
            try {
                node.flush();
            }
            catch (Throwable throwable) {}
        }
    }

    public IEvernoteAccount getAccountInfo() {
        return this.accountInfo;
    }
}

