/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Column2;
import org.xmind.ui.internal.spreadsheet.structures.Item2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell2
extends BranchStructureData {
    private Chart2 ownedChart;
    private Column2 ownedColumn;
    private Row2 ownedRow;
    private List<Item2> items = new ArrayList<Item2>();
    private Dimension prefContentSize = null;
    private int contentHeight = -1;
    private int contentWidth = -1;
    private Rectangle bounds = null;

    public Cell2(Chart2 ownedChart, Column2 ownedColumn, Row2 ownedRow) {
        super(ownedColumn.getHead());
        this.ownedChart = ownedChart;
        this.ownedColumn = ownedColumn;
        this.ownedRow = ownedRow;
    }

    public Chart2 getOwnedChart() {
        return this.ownedChart;
    }

    public Row2 getOwnedRow() {
        return this.ownedRow;
    }

    public Column2 getOwnedColumn() {
        return this.ownedColumn;
    }

    void addItem(Item2 item) {
        this.items.add(item);
        item.setOwnedCell(this);
    }

    void removeItem(Item2 item) {
        this.items.remove((Object)item);
        item.setOwnedCell(null);
    }

    public List<Item2> getItems() {
        return this.items;
    }

    public Dimension getPrefContentSize() {
        if (this.prefContentSize == null) {
            this.prefContentSize = this.calcPrefContentSize();
        }
        return this.prefContentSize;
    }

    private Dimension calcPrefContentSize() {
        int w = 0;
        int h = 0;
        int minorSpacing = this.getOwnedColumn().getMinorSpacing();
        Iterator<Item2> it = this.items.iterator();
        while (it.hasNext()) {
            Item2 item = it.next();
            IFigure itemFigure = item.getBranch().getFigure();
            Dimension size = itemFigure.getPreferredSize();
            w = Math.max(w, size.width);
            int bh = 0;
            IBranchPart parent = item.getBranch().getParentBranch();
            if (parent != null && !parent.getBoundaries().isEmpty()) {
                for (IBoundaryPart boundary : parent.getBoundaries()) {
                    List enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !item.getBranch().equals(enclosingBranches.get(0))) continue;
                    bh = boundary.getFigure().getInsets().getHeight();
                    if (boundary.getTitle() == null || boundary.getTitle().getFigure() == null) continue;
                    Dimension s = boundary.getTitle().getFigure().getPreferredSize();
                    bh += s.height;
                }
            }
            h += size.height;
            if (!it.hasNext()) continue;
            h += minorSpacing + bh;
        }
        IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getOwnedColumn().getHead(), (String)"org.xmind.ui.branchCache.insertion");
        RowHead insHead = (RowHead)MindMapUtils.getCache((IPart)this.getOwnedColumn().getHead(), (String)"org.xmind.ui.spreadsheet.cache.insertionRowHead");
        if (ins != null && this.getOwnedRow().getHead().equals(insHead)) {
            h += ins.getSize().height + minorSpacing;
        }
        return new Dimension(w, h);
    }

    public int getContentHeight() {
        if (this.contentHeight < 0) {
            this.contentHeight = this.calcContentHeight();
        }
        return this.contentHeight;
    }

    private int calcContentHeight() {
        if (!this.items.isEmpty()) {
            Item2 first = this.items.get(0);
            Item2 last = this.items.get(this.items.size() - 1);
            int height = last.getBranch().getFigure().getBounds().bottom() - 10 - first.getBranch().getFigure().getBounds().y;
            IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.branchCache.insertion");
            if (ins != null && (ins.getIndex() == 0 || ins.getIndex() == this.items.size()) && this.getOwnedRow().getHead().equals(MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.spreadsheet.cache.insertionRowHead"))) {
                height += ins.getSize().height + this.getOwnedColumn().getMajorSpacing();
            }
            int bh = 0;
            for (Item2 item : this.items) {
                List boundaries;
                IBranchPart parent = item.getBranch().getParentBranch();
                if (parent == null || (boundaries = parent.getBoundaries()).isEmpty()) continue;
                for (IBoundaryPart boundary : boundaries) {
                    List enclosingBranches = boundary.getEnclosingBranches();
                    if (enclosingBranches.isEmpty() || !item.getBranch().equals(enclosingBranches.get(0))) continue;
                    bh = boundary.getFigure().getInsets().getHeight() - this.getOwnedChart().getMinorSpacing() - 3;
                    if (boundary.getTitle() == null || boundary.getTitle().getFigure() == null) continue;
                    Dimension s = boundary.getTitle().getFigure().getPreferredSize();
                    bh += s.height;
                }
            }
            return height + bh;
        }
        return 0;
    }

    public int getContentWidth() {
        if (this.contentWidth < 0) {
            this.contentWidth = this.calcContentWidth();
        }
        return this.contentWidth;
    }

    private int calcContentWidth() {
        if (!this.items.isEmpty()) {
            Item2 first = this.items.get(0);
            Item2 last = this.items.get(this.items.size() - 1);
            int width = last.getBranch().getFigure().getBounds().right() - first.getBranch().getFigure().getBounds().x;
            IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.branchCache.insertion");
            if (ins != null && (ins.getIndex() == 0 || ins.getIndex() == this.items.size()) && this.getOwnedRow().getHead().equals(MindMapUtils.getCache((IPart)this.getBranch(), (String)"org.xmind.ui.spreadsheet.cache.insertionRowHead"))) {
                width += ins.getSize().width + this.getOwnedColumn().getMinorSpacing();
            }
            return width;
        }
        return 0;
    }

    public Item2 findItem(IBranchPart itemBranch) {
        for (Item2 item : this.items) {
            if (item.getBranch() != itemBranch) continue;
            return item;
        }
        return null;
    }

    public Item2 getPreviousItem(Item2 item) {
        int index = this.getItemIndex(item);
        if (index > 0) {
            return this.items.get(index - 1);
        }
        return null;
    }

    public Item2 getNextItem(Item2 item) {
        int index = this.getItemIndex(item);
        if (index < this.items.size() - 1) {
            return this.items.get(index + 1);
        }
        return null;
    }

    public int getItemIndex(Item2 item) {
        return this.items.indexOf((Object)item);
    }

    public int getX() {
        return this.getOwnedColumn().getLeft();
    }

    public int getY() {
        return this.getOwnedRow().getTop();
    }

    public int getWidth() {
        return this.getOwnedColumn().getWidth();
    }

    public int getHeight() {
        return this.getOwnedRow().getHeight();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        return this.bounds;
    }

    public String toString() {
        return "[" + this.getOwnedRow().toString() + ", " + this.getOwnedRow().toString() + "]";
    }
}

