/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.geom.Shapes;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGConstants;
import org.jhotdraw.samples.odg.figures.ODGBezierFigure;
import org.jhotdraw.samples.odg.figures.ODGFigure;
import org.jhotdraw.samples.odg.figures.ODGPathOutlineHandle;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class ODGPathFigure
extends AbstractAttributedCompositeFigure
implements ODGFigure {
    private transient GeneralPath cachedPath;
    private static final boolean DEBUG = false;

    public ODGPathFigure() {
        this.add(new ODGBezierFigure());
        ODGAttributeKeys.setDefaults(this);
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = ODGAttributeKeys.OPACITY.get(this);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage(Math.max(1, (int)((2.0 + drawingArea.width) * g.getTransform().getScaleX())), Math.max(1, (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY())), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    @Override
    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
            savedTransform = g.getTransform();
            g.transform((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this));
        }
        if (ODGAttributeKeys.FILL_STYLE.get(this) != ODGConstants.FillStyle.NONE && (paint = ODGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if (ODGAttributeKeys.STROKE_STYLE.get(this) != ODGConstants.StrokeStyle.NONE && (paint = ODGAttributeKeys.getStrokePaint(this)) != null) {
            g.setPaint(paint);
            g.setStroke(ODGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    public void drawFill(Graphics2D g) {
        boolean isClosed = (Boolean)ODGAttributeKeys.CLOSED.get(this.getChild(0));
        if (isClosed) {
            g.fill(this.getPath());
        }
    }

    @Override
    public void drawStroke(Graphics2D g) {
        g.draw(this.getPath());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPath = null;
        this.cachedDrawingArea = null;
    }

    protected GeneralPath getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = new GeneralPath();
            this.cachedPath.setWindingRule(ODGAttributeKeys.WINDING_RULE.get(this) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure child : this.getChildren()) {
                ODGBezierFigure b = (ODGBezierFigure)child;
                this.cachedPath.append(b.getBezierPath(), false);
            }
        }
        return this.cachedPath;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rx;
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if ((Integer)ODGAttributeKeys.STROKE_JOIN.get(this) == 0) {
                width *= ((Double)ODGAttributeKeys.STROKE_MITER_LIMIT.get(this)).doubleValue();
            } else if ((Integer)ODGAttributeKeys.STROKE_CAP.get(this) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            GeneralPath gp = this.getPath();
            Rectangle2D strokeRect = new Rectangle2D.Double(0.0, 0.0, width, width);
            if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
                gp = (GeneralPath)gp.clone();
                gp.transform((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this));
                strokeRect = ((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).createTransformedShape(strokeRect).getBounds2D();
            }
            Rectangle2D.Double r = (rx = gp.getBounds2D()) instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
            Geom.grow(r, ((RectangularShape)strokeRect).getWidth(), ((RectangularShape)strokeRect).getHeight());
            this.cachedDrawingArea = r;
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public final void write(DOMOutput out) throws IOException {
        throw new UnsupportedOperationException("Use ODGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput in) throws IOException {
        throw new UnsupportedOperationException("Use ODGStorableInput to read this Figure.");
    }

    @Override
    public boolean contains(Point2D.Double p) {
        this.getPath();
        if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)((AffineTransform)ODGAttributeKeys.TRANSFORM.get(this)).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        boolean isClosed = (Boolean)ODGAttributeKeys.CLOSED.get(this.getChild(0));
        double tolerance = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (isClosed) {
            if (this.getPath().contains(p)) {
                return true;
            }
            double grow = AttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * (Double)ODGAttributeKeys.STROKE_MITER_LIMIT.get(this)));
            if (gs.createStrokedShape(this.getPath()).contains(p)) {
                return true;
            }
            if (isClosed) {
                return false;
            }
        }
        return !isClosed && Shapes.outlineContains(this.getPath(), p, tolerance);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getChildCount() == 1 && this.getChild(0).getNodeCount() <= 2) {
            ODGBezierFigure b = this.getChild(0);
            b.setBounds(anchor, lead);
            this.invalidate();
        } else {
            super.setBounds(anchor, lead);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (ODGAttributeKeys.TRANSFORM.get(this) != null || (tx.getType() & 1) != tx.getType()) {
            if (ODGAttributeKeys.TRANSFORM.get(this) == null) {
                ODGAttributeKeys.TRANSFORM.basicSetClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)ODGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                ODGAttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            Gradient g;
            for (Figure f : this.getChildren()) {
                f.transform(tx);
            }
            if (ODGAttributeKeys.FILL_GRADIENT.get(this) != null && !ODGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (ODGAttributeKeys.STROKE_GRADIENT.get(this) != null && !ODGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                ODGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidate();
        Object[] restoreData = (Object[])geometry;
        ArrayList paths = (ArrayList)restoreData[0];
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).setBezierPath((BezierPath)paths.get(i));
        }
        ODGAttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[1]);
        ODGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        ODGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        ArrayList<BezierPath> paths = new ArrayList<BezierPath>(this.getChildCount());
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            paths.add(this.getChild(i).getBezierPath());
        }
        return new Object[]{paths, ODGAttributeKeys.TRANSFORM.getClone(this), ODGAttributeKeys.FILL_GRADIENT.getClone(this), ODGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public <T> void setAttribute(AttributeKey<T> key, T newValue) {
        super.setAttribute(key, newValue);
        this.invalidate();
    }

    @Override
    protected <T> void setAttributeOnChildren(AttributeKey<T> key, T newValue) {
    }

    @Override
    public boolean isEmpty() {
        for (Figure child : this.getChildren()) {
            ODGBezierFigure b = (ODGBezierFigure)child;
            if (b.getNodeCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                handles.add(new ODGPathOutlineHandle(this));
                for (Figure child : this.getChildren()) {
                    handles.addAll(((ODGBezierFigure)child).createHandles(this, detailLevel));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        if (ODGAttributeKeys.TRANSFORM.get(this) != null) {
            actions.add(new AbstractAction(labels.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.fireUndoableEditHappened(ODGAttributeKeys.TRANSFORM.setUndoable(ODGPathFigure.this, null));
                    ODGPathFigure.this.changed();
                }
            });
            actions.add(new AbstractAction(labels.getString("edit.flattenTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    final Object restoreData = ODGPathFigure.this.getTransformRestoreData();
                    AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                        @Override
                        public String getPresentationName() {
                            return labels.getString("flattenTransform");
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            ODGPathFigure.this.willChange();
                            ODGPathFigure.this.restoreTransformTo(restoreData);
                            ODGPathFigure.this.changed();
                        }

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            ODGPathFigure.this.willChange();
                            ODGPathFigure.this.restoreTransformTo(restoreData);
                            ODGPathFigure.this.flattenTransform();
                            ODGPathFigure.this.changed();
                        }
                    };
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.flattenTransform();
                    ODGPathFigure.this.changed();
                    ODGPathFigure.this.fireUndoableEditHappened(edit);
                }
            });
        }
        actions.add(new AbstractAction(labels.getString("closePath")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (Figure child : ODGPathFigure.this.getChildren()) {
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.CLOSED.setUndoable(child, true));
                    ODGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("openPath")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (Figure child : ODGPathFigure.this.getChildren()) {
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.CLOSED.setUndoable(child, false));
                    ODGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("windingRule.evenOdd")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODGPathFigure.this.willChange();
                ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.WINDING_RULE.setUndoable(ODGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD));
                ODGPathFigure.this.changed();
            }
        });
        actions.add(new AbstractAction(labels.getString("windingRule.nonZero")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODGAttributeKeys.WINDING_RULE.set(ODGPathFigure.this, AttributeKeys.WindingRule.NON_ZERO);
                ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.WINDING_RULE.setUndoable(ODGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD));
            }
        });
        return actions;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() % 2 == 0) {
            for (Figure child : this.getChildren()) {
                ODGBezierFigure bf = (ODGBezierFigure)child;
                int index = bf.getBezierPath().findSegment(p, (float)(5.0 / view.getScaleFactor()));
                if (index == -1) continue;
                bf.handleMouseClick(p, evt, view);
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int index, Figure figure) {
        super.add(index, (ODGBezierFigure)figure);
    }

    @Override
    public ODGBezierFigure getChild(int index) {
        return (ODGBezierFigure)super.getChild(index);
    }

    @Override
    public ODGPathFigure clone() {
        ODGPathFigure that = (ODGPathFigure)super.clone();
        return that;
    }

    public void flattenTransform() {
        this.willChange();
        AffineTransform tx = (AffineTransform)ODGAttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            for (Figure child : this.getChildren()) {
                ((ODGBezierFigure)child).transform(tx);
                ((ODGBezierFigure)child).flattenTransform();
            }
        }
        ODGAttributeKeys.TRANSFORM.basicSet(this, null);
        this.changed();
    }
}

