/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.portfolio.Commentable;

public class Dividend
implements Commentable {
    public final StockInfo stockInfo;
    public final double amount;
    public final SimpleDate date;
    private String comment = "";

    public Dividend(StockInfo stockInfo, double amount, SimpleDate date) {
        this.stockInfo = stockInfo;
        this.amount = amount;
        this.date = date;
    }

    public Dividend(Dividend dividend) {
        this.stockInfo = dividend.stockInfo;
        this.amount = dividend.amount;
        this.date = dividend.date;
        this.comment = dividend.comment;
    }

    public Dividend setStockInfo(StockInfo stockInfo) {
        Dividend dividend = new Dividend(stockInfo, this.amount, this.date);
        dividend.setComment(this.comment);
        return dividend;
    }

    public Dividend setAmount(double amount) {
        Dividend dividend = new Dividend(this.stockInfo, amount, this.date);
        dividend.setComment(this.comment);
        return dividend;
    }

    public Dividend setDate(SimpleDate date) {
        Dividend dividend = new Dividend(this.stockInfo, this.amount, date);
        dividend.setComment(this.comment);
        return dividend;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }
}

