/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractObjectStream;
import opennlp.tools.util.ObjectStream;

public class HashSumEventStream
extends AbstractObjectStream<Event> {
    private MessageDigest digest;

    public HashSumEventStream(ObjectStream<Event> eventStream) {
        super(eventStream);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Event read() throws IOException {
        Event event = (Event)super.read();
        if (event != null) {
            try {
                this.digest.update(event.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding is not available!", e);
            }
        }
        return event;
    }

    public BigInteger calculateHashSum() {
        return new BigInteger(1, this.digest.digest());
    }

    public void remove() {
    }
}

