/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.Reader;
import net.java.sen.SenFactory;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.StreamFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.StreamTagger2;
import org.apache.lucene.analysis.ja.tokenAttributes.BasicFormAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.ConjugationAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.CostAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.PronunciationsAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.ReadingsAttribute;
import org.apache.lucene.analysis.ja.tokenAttributes.SentenceStartAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class JapaneseTokenizer
extends Tokenizer {
    private final StreamTagger2 tagger;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final BasicFormAttribute basicFormAtt = (BasicFormAttribute)this.addAttribute(BasicFormAttribute.class);
    private final ConjugationAttribute conjugationAtt = (ConjugationAttribute)this.addAttribute(ConjugationAttribute.class);
    private final PartOfSpeechAttribute partOfSpeechAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);
    private final PronunciationsAttribute pronunciationsAtt = (PronunciationsAttribute)this.addAttribute(PronunciationsAttribute.class);
    private final ReadingsAttribute readingsAtt = (ReadingsAttribute)this.addAttribute(ReadingsAttribute.class);
    private final SentenceStartAttribute sentenceAtt = (SentenceStartAttribute)this.addAttribute(SentenceStartAttribute.class);
    private final CostAttribute costAtt = (CostAttribute)this.addAttribute(CostAttribute.class);
    private int accumulatedCost = 0;

    public JapaneseTokenizer(Reader in) {
        this(in, null, null);
    }

    public JapaneseTokenizer(Reader in, StreamFilter filter) {
        this(in, null, null);
    }

    public JapaneseTokenizer(Reader in, StreamFilter filter, String dictionaryDir) {
        super(in);
        StringTagger stringTagger = SenFactory.getStringTagger(dictionaryDir);
        if (filter != null) {
            stringTagger.addFilter(filter);
        }
        this.tagger = new StreamTagger2(stringTagger, in);
    }

    public boolean incrementToken() throws IOException {
        Token token = this.tagger.next();
        if (token == null) {
            return false;
        }
        this.clearAttributes();
        Morpheme m = token.getMorpheme();
        this.termAtt.setEmpty().append(token.getSurface());
        int cost = token.getCost();
        if (token.isSentenceStart()) {
            this.accumulatedCost = 0;
            this.sentenceAtt.setSentenceStart(true);
        }
        this.costAtt.setCost(cost - this.accumulatedCost);
        this.accumulatedCost = cost;
        this.basicFormAtt.setMorpheme(m);
        this.conjugationAtt.setMorpheme(m);
        this.partOfSpeechAtt.setMorpheme(m);
        this.pronunciationsAtt.setMorpheme(m);
        this.readingsAtt.setMorpheme(m);
        this.offsetAtt.setOffset(this.correctOffset(token.getStart()), this.correctOffset(token.end()));
        return true;
    }

    public void reset(Reader in) throws IOException {
        super.reset(in);
        this.tagger.reset(in);
        this.accumulatedCost = 0;
    }

    public void end() throws IOException {
        int finalOffset = this.correctOffset(this.tagger.end());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }
}

