/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionAttributeMap;
import org.apache.mina.core.session.IoSessionDataStructureFactory;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;

public class DefaultIoSessionDataStructureFactory
implements IoSessionDataStructureFactory {
    public IoSessionAttributeMap getAttributeMap(IoSession ioSession) throws Exception {
        return new DefaultIoSessionAttributeMap();
    }

    public WriteRequestQueue getWriteRequestQueue(IoSession ioSession) throws Exception {
        return new DefaultWriteRequestQueue();
    }

    private static class DefaultWriteRequestQueue
    implements WriteRequestQueue {
        private final Queue<WriteRequest> q = new ConcurrentLinkedQueue<WriteRequest>();

        public void dispose(IoSession ioSession) {
        }

        public synchronized boolean isEmpty(IoSession ioSession) {
            return this.q.isEmpty();
        }

        public synchronized void offer(IoSession ioSession, WriteRequest writeRequest) {
            this.q.offer(writeRequest);
        }

        public synchronized WriteRequest poll(IoSession ioSession) {
            return this.q.poll();
        }

        public String toString() {
            return this.q.toString();
        }
    }

    private static class DefaultIoSessionAttributeMap
    implements IoSessionAttributeMap {
        private final Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>(4);

        public Object getAttribute(IoSession ioSession, Object object, Object object2) {
            if (object == null) {
                throw new IllegalArgumentException("key");
            }
            Object object3 = this.attributes.get(object);
            if (object3 == null) {
                return object2;
            }
            return object3;
        }

        public Object setAttribute(IoSession ioSession, Object object, Object object2) {
            if (object == null) {
                throw new IllegalArgumentException("key");
            }
            if (object2 == null) {
                return this.attributes.remove(object);
            }
            return this.attributes.put(object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setAttributeIfAbsent(IoSession ioSession, Object object, Object object2) {
            Object object3;
            if (object == null) {
                throw new IllegalArgumentException("key");
            }
            if (object2 == null) {
                return null;
            }
            Map<Object, Object> map = this.attributes;
            synchronized (map) {
                object3 = this.attributes.get(object);
                if (object3 == null) {
                    this.attributes.put(object, object2);
                }
            }
            return object3;
        }

        public Object removeAttribute(IoSession ioSession, Object object) {
            if (object == null) {
                throw new IllegalArgumentException("key");
            }
            return this.attributes.remove(object);
        }

        public void dispose(IoSession ioSession) throws Exception {
        }
    }
}

