/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.ant;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.sonarsource.scanner.ant.SonarQubeTask;

public final class SonarQubeTaskUtils {
    private SonarQubeTaskUtils() {
    }

    public static URL getJarPath() {
        String uri;
        String pathToClass = "/" + SonarQubeTask.class.getName().replace('.', '/') + ".class";
        URL url = SonarQubeTask.class.getResource(pathToClass);
        if (url != null && (uri = SonarQubeTaskUtils.extractURI(pathToClass, url.toString())) != null) {
            try {
                return new URL(uri);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    static String extractURI(String pathToClass, String path) {
        String uri = null;
        if (path.startsWith("jar:file:")) {
            int bang = path.indexOf(33);
            uri = path.substring(4, bang);
        } else if (path.startsWith("file:")) {
            int tail = path.indexOf(pathToClass);
            uri = path.substring(0, tail);
        }
        return uri;
    }

    public static int getAntLoggerLever(Project project) {
        try {
            Vector listeners = project.getBuildListeners();
            for (BuildListener listener : listeners) {
                if (!(listener instanceof DefaultLogger)) continue;
                DefaultLogger logger = (DefaultLogger)listener;
                Field field = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                field.setAccessible(true);
                return (Integer)field.get(logger);
            }
            return 2;
        }
        catch (Exception e) {
            return 2;
        }
    }

    public static String getTaskVersion() {
        String string;
        block8: {
            InputStream in = SonarQubeTask.class.getResourceAsStream("version.txt");
            try {
                Properties props = new Properties();
                props.load(in);
                string = props.getProperty("version");
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BuildException("Could not load the version information for SonarQube Ant Task", (Throwable)e);
                }
            }
            in.close();
        }
        return string;
    }
}

