/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.auth;

import davmail.Settings;
import davmail.exchange.auth.ExchangeAuthenticator;
import davmail.exchange.auth.O365Token;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;

public class O365StoredTokenAuthenticator
implements ExchangeAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(O365StoredTokenAuthenticator.class);
    String resource = "https://outlook.office365.com";
    URI ewsUrl = URI.create(this.resource + "/EWS/Exchange.asmx");
    private String username;
    private O365Token token;

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void authenticate() throws IOException {
        String clientId = Settings.getProperty("davmail.oauth.clientId", "facd6cff-a294-4415-b59f-c5b01937d7bd");
        String redirectUri = Settings.getProperty("davmail.oauth.redirectUri", "https://login.microsoftonline.com/common/oauth2/nativeclient");
        String tenantId = Settings.getProperty("davmail.oauth.tenantId", "common");
        String refreshToken = Settings.getProperty("davmail.oauth." + this.username.toLowerCase() + ".refreshToken");
        if (refreshToken == null) {
            refreshToken = Settings.getProperty("davmail.oauth.refreshToken");
        }
        String accessToken = Settings.getProperty("davmail.oauth.accessToken");
        if (refreshToken == null && accessToken == null) {
            LOGGER.warn((Object)("No stored Oauth refresh token found for " + this.username));
            throw new IOException("No stored Oauth refresh token found for " + this.username);
        }
        this.token = new O365Token(tenantId, clientId, redirectUri);
        if (accessToken != null) {
            this.token.setAccessToken(accessToken);
        } else {
            this.token.setRefreshToken(refreshToken);
            this.token.refreshToken();
        }
    }

    @Override
    public O365Token getToken() {
        return this.token;
    }

    @Override
    public URI getExchangeUri() {
        return this.ewsUrl;
    }
}

