/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.Settings;
import davmail.exchange.ExchangeSession;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class FolderLoadThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(FolderLoadThread.class);
    boolean isComplete = false;
    ExchangeSession.Folder folder;
    IOException exception;

    FolderLoadThread(String threadName, ExchangeSession.Folder folder) {
        super(threadName + "-LoadFolder");
        this.setDaemon(true);
        this.folder = folder;
    }

    @Override
    public void run() {
        try {
            this.folder.loadMessages();
        }
        catch (IOException e) {
            this.exception = e;
        }
        catch (Exception e) {
            LOGGER.error((Object)(e + " " + e.getMessage()), (Throwable)e);
            this.exception = new IOException(e.getMessage(), e);
        }
        finally {
            this.isComplete = true;
        }
    }

    public static void loadFolder(ExchangeSession.Folder folder, OutputStream outputStream) throws InterruptedException, IOException {
        FolderLoadThread folderLoadThread = new FolderLoadThread(FolderLoadThread.currentThread().getName(), folder);
        folderLoadThread.start();
        while (!folderLoadThread.isComplete) {
            folderLoadThread.join(20000L);
            LOGGER.debug((Object)("Still loading " + folder.folderPath + " (" + folder.count() + " messages)"));
            if (!Settings.getBooleanProperty("davmail.enableKeepAlive", false)) continue;
            try {
                outputStream.write(32);
                outputStream.flush();
            }
            catch (SocketException e) {
                folderLoadThread.interrupt();
                throw e;
            }
        }
        if (folderLoadThread.exception != null) {
            throw folderLoadThread.exception;
        }
    }
}

