/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javacc.parser.Options;
import org.javacc.parser.RStringLiteral;

public class TokenizerData {
    public String parserName;
    public String decls;
    public Map<Integer, List<String>> literalSequence;
    public Map<Integer, List<Integer>> literalKinds;
    public Map<Integer, Integer> kindToNfaStartState;
    public final Map<Integer, NfaState> nfa = new HashMap<Integer, NfaState>();
    public Map<Integer, MatchInfo> allMatches = new HashMap<Integer, MatchInfo>();
    public Map<Integer, Integer> initialStates;
    public Map<Integer, Integer> wildcardKind;
    public String[] lexStateNames;
    public int defaultLexState;

    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    public void setDecls(String decls) {
        this.decls = decls;
    }

    public void setLiteralSequence(Map<Integer, List<String>> literalSequence) {
        this.literalSequence = literalSequence;
    }

    public void setLiteralKinds(Map<Integer, List<Integer>> literalKinds) {
        this.literalKinds = literalKinds;
    }

    public void setKindToNfaStartState(Map<Integer, Integer> kindToNfaStartState) {
        this.kindToNfaStartState = kindToNfaStartState;
    }

    public void addNfaState(int index, Set<Character> characters, Set<Integer> nextStates, Set<Integer> compositeStates, int kind) {
        NfaState nfaState = new NfaState(index, characters, nextStates, compositeStates, kind);
        this.nfa.put(index, nfaState);
    }

    public void setInitialStates(Map<Integer, Integer> initialStates) {
        this.initialStates = initialStates;
    }

    public void setWildcardKind(Map<Integer, Integer> wildcardKind) {
        this.wildcardKind = wildcardKind;
    }

    public void setLexStateNames(String[] lexStateNames) {
        this.lexStateNames = lexStateNames;
    }

    public void setDefaultLexState(int defaultLexState) {
        this.defaultLexState = defaultLexState;
    }

    public void updateMatchInfo(Map<Integer, String> actions, int[] newLexStateIndices, long[] toSkip, long[] toSpecial, long[] toMore, long[] toToken) {
        for (int i = 0; i < newLexStateIndices.length; ++i) {
            int vectorIndex = i >> 6;
            long bits = 1L << (i & 0x3F);
            MatchType matchType = MatchType.TOKEN;
            if (toSkip.length > vectorIndex && (toSkip[vectorIndex] & bits) != 0L) {
                matchType = MatchType.SKIP;
            } else if (toSpecial.length > vectorIndex && (toSpecial[vectorIndex] & bits) != 0L) {
                matchType = MatchType.SPECIAL_TOKEN;
            } else if (toMore.length > vectorIndex && (toMore[vectorIndex] & bits) != 0L) {
                matchType = MatchType.MORE;
            } else {
                assert (toToken.length > vectorIndex && (toToken[vectorIndex] & bits) != 0L);
                matchType = MatchType.TOKEN;
            }
            MatchInfo matchInfo = new MatchInfo(Options.getIgnoreCase() ? null : RStringLiteral.allImages[i], i, matchType, newLexStateIndices[i], actions.get(i));
            this.allMatches.put(i, matchInfo);
        }
    }

    public static class MatchInfo {
        public String image;
        public int kind;
        public MatchType matchType;
        public int newLexState;
        public String action;

        public MatchInfo(String image, int kind, MatchType matchType, int newLexState, String action) {
            this.image = image;
            this.kind = kind;
            this.matchType = matchType;
            this.newLexState = newLexState;
            this.action = action;
        }
    }

    public static enum MatchType {
        SKIP,
        SPECIAL_TOKEN,
        MORE,
        TOKEN;

    }

    public static class NfaState {
        public int index;
        public Set<Character> characters;
        public Set<Integer> nextStates;
        public Set<Integer> compositeStates;
        public int kind;

        NfaState(int index, Set<Character> characters, Set<Integer> nextStates, Set<Integer> compositeStates, int kind) {
            this.index = index;
            this.characters = characters;
            this.nextStates = nextStates;
            this.kind = kind;
            this.compositeStates = compositeStates;
        }
    }
}

