/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.parser.JavaCCGlobals;

final class IO {
    private String ifn = "<uninitialized input>";
    private String ofn;
    private Reader in;
    private PrintWriter out;
    private PrintStream msg = System.out;
    private PrintStream err = System.err;

    IO() {
    }

    String getInputFileName() {
        return this.ifn;
    }

    Reader getIn() {
        return this.in;
    }

    String getOutputFileName() {
        return this.ofn;
    }

    PrintWriter getOut() {
        return this.out;
    }

    PrintStream getMsg() {
        return this.msg;
    }

    PrintStream getErr() {
        return this.err;
    }

    void print(String s) {
        this.out.print(s);
    }

    void println(String s) {
        this.out.print(s);
        this.out.println();
    }

    void println() {
        this.out.println();
    }

    void closeAll() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.msg != null) {
            this.msg.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
    }

    private String create_output_file_name(String i) {
        String o = JJTreeOptions.getOutputFile();
        if (o.equals("")) {
            String suffix;
            int di;
            int s = i.lastIndexOf(File.separatorChar);
            if (s >= 0) {
                i = i.substring(s + 1);
            }
            o = (di = i.lastIndexOf(46)) == -1 ? i + ".jj" : ((suffix = i.substring(di)).equals(".jj") ? i + ".jj" : i.substring(0, di) + ".jj");
        }
        return o;
    }

    void setInput(String fn) throws JJTreeIOException {
        try {
            File fp = new File(fn);
            if (!fp.exists()) {
                throw new JJTreeIOException("File " + fn + " not found.");
            }
            if (fp.isDirectory()) {
                throw new JJTreeIOException(fn + " is a directory. Please use a valid file name.");
            }
            if (JavaCCGlobals.isGeneratedBy("JJTree", fn)) {
                throw new JJTreeIOException(fn + " was generated by jjtree.  Cannot run jjtree again.");
            }
            this.ifn = fp.getPath();
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.ifn), JJTreeOptions.getGrammarEncoding()));
        }
        catch (NullPointerException ne) {
            throw new JJTreeIOException(ne.toString());
        }
        catch (SecurityException se) {
            throw new JJTreeIOException("Security violation while trying to open " + fn);
        }
        catch (FileNotFoundException e) {
            throw new JJTreeIOException("File " + fn + " not found.");
        }
        catch (IOException ioe) {
            throw new JJTreeIOException(ioe.toString());
        }
    }

    void setOutput() throws JJTreeIOException {
        try {
            JavaCCGlobals.createOutputDir(JJTreeOptions.getJJTreeOutputDirectory());
            File ofile = new File(JJTreeOptions.getJJTreeOutputDirectory(), this.create_output_file_name(this.ifn));
            this.ofn = ofile.toString();
            this.out = new PrintWriter(new FileWriter(ofile));
        }
        catch (IOException ioe) {
            throw new JJTreeIOException("Can't create output file " + this.ofn);
        }
    }
}

