/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.project;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.Option;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.LcsHintLoadSpecChooser;
import ghidra.app.util.importer.LoadSpecChooser;
import ghidra.app.util.importer.LoaderArgsOptionChooser;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MultipleProgramsStrategy;
import ghidra.app.util.importer.OptionChooser;
import ghidra.app.util.importer.SingleLoaderFilter;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderService;
import ghidra.framework.Application;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.Options;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.framework.store.LockException;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefaultLanguageService;
import ghidra.test.ProjectTestUtils;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class GhidraProject {
    private static final TaskMonitor MONITOR = TaskMonitor.DUMMY;
    private GhidraProjectManager projectManager = new GhidraProjectManager();
    private boolean deleteOnClose = false;
    private Project project;
    private ProjectData projectData;
    private HashMap<Program, Integer> openPrograms = new HashMap();

    public static GhidraProject openProject(String projectsDir, String projectName) throws IOException {
        return new GhidraProject(projectsDir, projectName, false);
    }

    public static GhidraProject openProject(String projectsDir, String projectName, boolean restoreProject) throws IOException {
        return new GhidraProject(projectsDir, projectName, restoreProject);
    }

    private GhidraProject(String projectParentDir, String projectName, boolean restoreProject) throws IOException {
        if (!Application.isInitialized()) {
            throw new AssertException("The GhidraProject requires the system to be initialized before usage.  See GhidraApplication.initialize() for more information.");
        }
        ProjectLocator projectLocator = new ProjectLocator(projectParentDir, projectName);
        try {
            this.project = this.projectManager.openProject(projectLocator, restoreProject, false);
            if (this.project == null) {
                throw new IOException("Failed to open project: " + projectName);
            }
            this.projectData = this.project.getProjectData();
        }
        catch (MalformedURLException e) {
            throw new IOException("Bad Project URL: " + projectLocator, e);
        }
        catch (NotFoundException e) {
            throw new IOException("Project not found: " + projectLocator, e);
        }
        catch (NotOwnerException e) {
            throw new IOException("Not project owner: " + projectName, e);
        }
        catch (LockException e) {
            throw new IOException("Project is locked: " + projectName, e);
        }
    }

    public static GhidraProject createProject(String projectDirPath, String projectName, boolean temporary) throws IOException {
        GhidraProject.deletePreviousProject(projectDirPath, projectName);
        return new GhidraProject(projectDirPath, projectName, null, temporary);
    }

    public static RepositoryAdapter getServerRepository(String host, int port, String repositoryName, boolean createIfNeeded) throws DuplicateNameException {
        RepositoryServerAdapter repositoryServer = ClientUtil.getRepositoryServer((String)host, (int)port, (boolean)true);
        if (!repositoryServer.isConnected()) {
            return null;
        }
        try {
            boolean exists = false;
            for (String name : repositoryServer.getRepositoryNames()) {
                if (!name.equals(repositoryName)) continue;
                exists = true;
                break;
            }
            if (exists) {
                return repositoryServer.getRepository(repositoryName);
            }
            return repositoryServer.createRepository(repositoryName);
        }
        catch (NotConnectedException e) {
            Msg.error(GhidraProject.class, (Object)"Unexpected exception getting server repository", (Throwable)e);
        }
        catch (IOException e) {
            ClientUtil.handleException(null, (Exception)e, (String)"Get Repository", (boolean)false, null);
        }
        return null;
    }

    private GhidraProject(Project project) {
        if (!Application.isInitialized()) {
            throw new AssertException("The GhidraProject requires the system to be initialized before usage.  See GhidraApplication.initialize() for more information.");
        }
        this.project = project;
        this.projectData = project.getProjectData();
    }

    private GhidraProject(String projectParentDir, String projectName, RepositoryAdapter repository, boolean temporary) throws IOException {
        if (!Application.isInitialized()) {
            throw new AssertException("The GhidraProject requires the system to be initialized before usage.  See GhidraApplication.initialize() for more information.");
        }
        ProjectLocator projectLocator = new ProjectLocator(projectParentDir, projectName);
        try {
            this.deleteOnClose = temporary;
            this.project = this.projectManager.createProject(projectLocator, null, !temporary);
            if (this.project == null) {
                throw new IOException("Failed to create project: " + projectName);
            }
            this.projectData = this.project.getProjectData();
        }
        catch (OverlappingFileLockException e) {
            throw new IOException("Unable to lock project: " + projectLocator);
        }
        catch (MalformedURLException e) {
            throw new IOException("Bad Project URL: " + projectLocator);
        }
    }

    public DefaultProjectManager getProjectManager() {
        return this.projectManager;
    }

    public Project getProject() {
        return this.project;
    }

    public void close() {
        ProjectLocator projectLocator;
        for (Program p : this.openPrograms.keySet()) {
            int id = this.openPrograms.get(p);
            if (id >= 0) {
                p.endTransaction(id, true);
            }
            p.release((Object)this);
        }
        this.openPrograms.clear();
        if (this.project != null) {
            this.project.close();
            this.project = null;
        }
        if (this.deleteOnClose && (projectLocator = this.projectData.getProjectLocator()).getMarkerFile().exists()) {
            this.projectManager.deleteProject(projectLocator);
        }
    }

    public void setDeleteOnClose(boolean toDelete) {
        this.deleteOnClose = toDelete;
    }

    public void close(Program program) {
        Integer id = this.openPrograms.remove(program);
        if (id != null) {
            if (id >= 0) {
                program.endTransaction(id.intValue(), true);
            }
            program.release((Object)this);
        }
    }

    public Program openProgram(String folderPath, String programName, boolean readOnly) throws IOException {
        String programPath = folderPath + "/" + programName;
        DomainFile df = this.projectData.getFile(programPath);
        if (df == null) {
            throw new FileNotFoundException("File not found: " + programPath);
        }
        if (Program.class.isAssignableFrom(df.getDomainObjectClass())) {
            Program p;
            try {
                p = readOnly ? (Program)df.getReadOnlyDomainObject((Object)this, -1, MONITOR) : (Program)df.getDomainObject((Object)this, true, false, MONITOR);
            }
            catch (VersionException e) {
                throw new IOException(e.getMessage());
            }
            catch (CancelledException e) {
                throw new IOException("Cancelled");
            }
            this.initializeProgram(p, readOnly);
            return p;
        }
        throw new IOException("File is not a program: " + programPath);
    }

    public void save(Program program) throws IOException {
        int id = -1;
        Integer idInt = this.openPrograms.get(program);
        if (idInt != null) {
            id = idInt;
        }
        if (id >= 0) {
            program.endTransaction(id, true);
        }
        try {
            program.getDomainFile().save(MONITOR);
        }
        catch (CancelledException e) {
            throw new IOException("Cancelled");
        }
        if (id >= 0) {
            this.openPrograms.put(program, new Integer(program.startTransaction("")));
        }
    }

    public DomainFolder getRootFolder() {
        return this.projectData.getRootFolder();
    }

    public void saveAs(Program program, String folderPath, String name, boolean overWrite) throws InvalidNameException, IOException {
        if (program == null) {
            throw new IllegalArgumentException("Program is null!");
        }
        int id = -1;
        Integer intID = this.openPrograms.get(program);
        if (intID != null) {
            id = intID;
        }
        if (id >= 0) {
            program.endTransaction(id, true);
        }
        boolean success = false;
        try {
            DomainFolder folder = this.projectData.getFolder(folderPath);
            try {
                DomainFile df;
                if (folder == null) {
                    throw new IOException("folder not found: " + folderPath);
                }
                if (overWrite && (df = folder.getFile(name)) != null) {
                    df.delete();
                }
                folder.createFile(name, (DomainObject)program, MONITOR);
                success = true;
            }
            catch (DuplicateFileException e) {
                if (overWrite) {
                    throw new IOException("Failed to overwrite existing project file: " + name);
                }
                throw e;
            }
        }
        catch (CancelledException e1) {
            throw new IOException("Cancelled");
        }
        finally {
            if (success || id >= 0) {
                this.openPrograms.put(program, new Integer(program.startTransaction("")));
            }
        }
    }

    public void saveAsPackedFile(Program program, File file, boolean overWrite) throws InvalidNameException, IOException {
        if (program == null) {
            throw new IllegalArgumentException("Program is null!");
        }
        int id = -1;
        Integer intID = this.openPrograms.get(program);
        if (intID != null) {
            id = intID;
        }
        if (id >= 0) {
            program.endTransaction(id, true);
        }
        boolean success = false;
        try {
            if (file.exists()) {
                if (overWrite) {
                    if (!file.delete()) {
                        throw new IOException("Failed to overwrite existing project file: " + file);
                    }
                } else {
                    throw new DuplicateFileException("File already exists: " + file);
                }
            }
            program.saveToPackedFile(file, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException e1) {
            throw new IOException("Cancelled");
        }
        finally {
            if (success || id >= 0) {
                this.openPrograms.put(program, new Integer(program.startTransaction("")));
            }
        }
    }

    public void checkPoint(Program program) {
        Integer id = this.openPrograms.get(program);
        if (id == null || id < 0) {
            throw new IllegalStateException("Cannot checkpoint a read-only program");
        }
        program.endTransaction(id.intValue(), true);
        this.openPrograms.put(program, new Integer(program.startTransaction("")));
    }

    public void rollback(Program program) {
        Integer id = this.openPrograms.get(program);
        if (id == null || id < 0) {
            throw new IllegalStateException("Cannot rollback a read-only program");
        }
        program.endTransaction(id.intValue(), false);
        this.openPrograms.put(program, new Integer(program.startTransaction("")));
    }

    public static void analyze(Program program) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.initializeOptions();
        mgr.reAnalyzeAll(null);
        mgr.startAnalysis(MONITOR);
    }

    public void analyze(Program program, boolean debug) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.setDebug(debug);
        GhidraProject.analyze(program);
    }

    public Options getAnalysisOptions(Program program) {
        return program.getOptions("Analyzers");
    }

    public void execute(Command cmd, Program program) {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        cmd.applyTo((DomainObject)program);
        mgr.initializeOptions();
        mgr.startAnalysis(MONITOR);
    }

    private void initializeProgram(Program program, boolean readOnly) {
        if (program == null) {
            return;
        }
        int id = -1;
        if (!readOnly) {
            id = program.startTransaction("Batch Processing");
            AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
            mgr.initializeOptions();
        }
        this.openPrograms.put(program, new Integer(id));
    }

    public Program importProgram(File file, Language language, CompilerSpec compilerSpec) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        return this.importProgram(file, (DomainFolder)null, language, compilerSpec);
    }

    public Program importProgram(File file, DomainFolder domainFolder, Language language, CompilerSpec compilerSpec) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        MessageLog messageLog = new MessageLog();
        Program program = AutoImporter.importByLookingForLcs(file, domainFolder, language, compilerSpec, this, messageLog, MONITOR);
        this.initializeProgram(program, false);
        return program;
    }

    public Program importProgram(File file, Processor processor) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        LanguageService svc = DefaultLanguageService.getLanguageService();
        Language language = svc.getDefaultLanguage(processor);
        CompilerSpec compilerSpec = language.getDefaultCompilerSpec();
        return this.importProgram(file, language, compilerSpec);
    }

    public Program importProgram(File file, Class<? extends Loader> loaderClass) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        MessageLog messageLog = new MessageLog();
        Program program = AutoImporter.importByUsingSpecificLoaderClass(file, null, loaderClass, null, this, messageLog, MONITOR);
        this.initializeProgram(program, false);
        return program;
    }

    public Program importProgram(File file, Class<? extends Loader> loaderClass, Language language, CompilerSpec compilerSpec) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        MessageLog messageLog = new MessageLog();
        SingleLoaderFilter loaderFilter = new SingleLoaderFilter(loaderClass, null);
        LcsHintLoadSpecChooser opinionChoose = new LcsHintLoadSpecChooser(language, compilerSpec);
        List<Program> programs = AutoImporter.importFresh(file, null, (Object)this, messageLog, MONITOR, (Predicate<Loader>)loaderFilter, (LoadSpecChooser)opinionChoose, null, (OptionChooser)new LoaderArgsOptionChooser(loaderFilter), MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    public Program importProgram(File file) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        return this.importProgram(file, (DomainFolder)null);
    }

    public Program importProgram(File file, DomainFolder domainFolder) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        MessageLog messageLog = new MessageLog();
        Program program = AutoImporter.importByUsingBestGuess(file, domainFolder, (Object)this, messageLog, MONITOR);
        this.initializeProgram(program, false);
        return program;
    }

    public Program importProgramFast(File file) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        Program program = this.importByStealingCodeFromAutoImporterByUsingBestGuess(file);
        this.initializeProgram(program, false);
        return program;
    }

    private static void deletePreviousProject(String projectDirectoryPath, String projectName) {
        ProjectLocator url = new ProjectLocator(projectDirectoryPath, projectName);
        File projectDir = url.getProjectDir();
        if (!projectDir.exists()) {
            return;
        }
        if (!ProjectTestUtils.deleteProject(projectDirectoryPath, projectName)) {
            throw new IllegalStateException("Unable to delete test project");
        }
    }

    private Program importByStealingCodeFromAutoImporterByUsingBestGuess(File file) throws CancelledException, DuplicateNameException, InvalidNameException, VersionException, IOException {
        MessageLog messageLog = new MessageLog();
        String programNameOverride = null;
        OptionChooser EMPTY_OPTIONS = (optionChoices, addressFactory) -> {
            Option option = new Option("Create Export Symbol Files", false);
            ArrayList<Option> arrayList = new ArrayList<Option>();
            arrayList.add(option);
            return arrayList;
        };
        List<Program> programs = AutoImporter.importFresh(file, null, (Object)this, messageLog, MONITOR, LoaderService.ACCEPT_ALL, LoadSpecChooser.CHOOSE_THE_FIRST_PREFERRED, programNameOverride, EMPTY_OPTIONS, MultipleProgramsStrategy.ONE_PROGRAM_OR_NULL);
        if (programs != null && programs.size() == 1) {
            return programs.get(0);
        }
        return null;
    }

    private static class GhidraProjectManager
    extends DefaultProjectManager {
        private GhidraProjectManager() {
        }
    }
}

