/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.DyldCacheProgramBuilder;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DyldCacheLoader
extends AbstractLibrarySupportLoader {
    public static final String DYLD_CACHE_NAME = "DYLD Cache";
    static final String PROCESS_SYMBOLS_OPTION_NAME = "Process symbols";
    static final boolean PROCESS_SYMBOLS_OPTION_DEFAULT = true;
    static final String CREATE_DYLIB_SECTIONS_OPTION_NAME = "Create DYLIB section memory blocks";
    static final boolean CREATE_DYLIB_SECTIONS_OPTION_DEFAULT = false;
    static final String ADD_RELOCATION_ENTRIES_OPTION_NAME = "Add relocation entries for fixed chain pointers";
    static final boolean ADD_RELOCATION_ENTRIES_OPTION_DEFAULT = false;
    static final String COMBINE_SPLIT_FILES_OPTION_NAME = "Auto import and combine split DYLD Cache files";
    static final boolean COMBINE_SPLIT_FILES_OPTION_DEFAULT = true;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (!DyldCacheUtils.isDyldCache(provider)) {
            return loadSpecs;
        }
        try {
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(provider, true));
            DyldArchitecture architecture = header.getArchitecture();
            if (architecture != null) {
                List<QueryResult> results = QueryOpinionService.query(this.getName(), architecture.getProcessor(), null);
                for (QueryResult result : results) {
                    loadSpecs.add(new LoadSpec((Loader)this, header.getBaseAddress(), result));
                }
                if (loadSpecs.isEmpty()) {
                    loadSpecs.add(new LoadSpec((Loader)this, header.getBaseAddress(), true));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            DyldCacheProgramBuilder.buildProgram(program, provider, MemoryBlockUtils.createFileBytes(program, provider, monitor), this.shouldProcessSymbols(options), this.shouldCreateDylibSections(options), this.shouldAddRelocationEntries(options), this.shouldCombineSplitFiles(options), log, monitor);
        }
        catch (CancelledException e) {
            return;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        if (!loadIntoProgram) {
            list.add(new Option(PROCESS_SYMBOLS_OPTION_NAME, true, Boolean.class, "-loader-processSymbols"));
            list.add(new Option(CREATE_DYLIB_SECTIONS_OPTION_NAME, false, Boolean.class, "-loader-createDylibSections"));
            list.add(new Option(ADD_RELOCATION_ENTRIES_OPTION_NAME, false, Boolean.class, "-loader-addRelocationEntries"));
            list.add(new Option(COMBINE_SPLIT_FILES_OPTION_NAME, true, Boolean.class, "-loader-combineSplitFiles"));
        }
        return list;
    }

    private boolean shouldProcessSymbols(List<Option> options) {
        return OptionUtils.getOption(PROCESS_SYMBOLS_OPTION_NAME, options, true);
    }

    private boolean shouldCreateDylibSections(List<Option> options) {
        return OptionUtils.getOption(CREATE_DYLIB_SECTIONS_OPTION_NAME, options, false);
    }

    private boolean shouldAddRelocationEntries(List<Option> options) {
        return OptionUtils.getOption(ADD_RELOCATION_ENTRIES_OPTION_NAME, options, false);
    }

    private boolean shouldCombineSplitFiles(List<Option> options) {
        return OptionUtils.getOption(COMBINE_SPLIT_FILES_OPTION_NAME, options, true);
    }

    @Override
    public String getName() {
        return DYLD_CACHE_NAME;
    }
}

