/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html.diff;

import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffInput;
import ghidra.app.util.html.diff.DiffLines;
import ghidra.app.util.html.diff.DiffLinesValidator;
import ghidra.util.exception.AssertException;
import java.util.List;

public class DataTypeDiffBuilder {
    protected static final String EMPTY_TAG = "<I></I>";
    protected static final String BR = "<BR>";

    private DataTypeDiffBuilder() {
    }

    public static DataTypeDiff diffLines(DataTypeDiffInput left, DataTypeDiffInput right) {
        DiffLines leftLines = new DiffLines(left);
        DiffLines rightLines = new DiffLines(right);
        DataTypeDiffBuilder.padLines(leftLines, rightLines);
        DataTypeDiffBuilder.highlightDiffLineDiferences(leftLines, rightLines);
        return new DataTypeDiff(leftLines, rightLines);
    }

    public static DataTypeDiff diffHeader(DataTypeDiffInput left, DataTypeDiffInput right) {
        DataTypeDiff result = DataTypeDiffBuilder.diffLines(left, right);
        return result;
    }

    public static void padLines(DiffLines leftLines, DiffLines rightLines) {
        int otherLength;
        int length = leftLines.size();
        if (length == (otherLength = rightLines.size())) {
            return;
        }
        int maxLength = Math.max(length, otherLength);
        for (int i = 0; i < maxLength; ++i) {
            String paddingText;
            String string = paddingText = i == 0 ? EMPTY_TAG : BR;
            if (i >= length) {
                leftLines.add(new TextLine(paddingText));
                continue;
            }
            if (i < otherLength) continue;
            rightLines.add(new TextLine(paddingText));
        }
    }

    public static DataTypeDiff diffBody(DataTypeDiffInput left, DataTypeDiffInput right) {
        DiffLinesValidator leftDiff = new DiffLinesValidator(left, true);
        DiffLinesValidator rightDiff = new DiffLinesValidator(right, false);
        DataTypeDiffBuilder.alignRows(leftDiff, rightDiff);
        DiffLines leftLines = leftDiff.getValidatedLines();
        DiffLines rightLines = rightDiff.getValidatedLines();
        DataTypeDiffBuilder.removeExcessEmptyRows(leftLines, rightLines);
        return new DataTypeDiff(leftLines, rightLines);
    }

    private static void alignRows(DiffLinesValidator leftValidator, DiffLinesValidator rightValidator) {
        while (!leftValidator.isDone() || !rightValidator.isDone()) {
            DataTypeDiffBuilder.validateNextLine(leftValidator, rightValidator);
            DataTypeDiffBuilder.validateNextLine(rightValidator, leftValidator);
        }
    }

    private static void validateNextLine(DiffLinesValidator validator1, DiffLinesValidator validator2) {
        if (validator1.isDone()) {
            return;
        }
        ValidatableLine line1 = validator1.getLine();
        if (line1 == null) {
            return;
        }
        ValidatableLine line2 = validator2.getLine();
        if (line2 == null) {
            PlaceHolderLine placeholder = validator2.insertMismatchPlaceholder(validator2.getMarkerPosition(), line1);
            line1.setValidationLine(placeholder);
            validator1.increment();
            return;
        }
        if (line1.matches(line2)) {
            line1.setValidationLine(line2);
            validator2.increment();
            validator1.increment();
            return;
        }
        Integer list2MatchForLine1 = DataTypeDiffBuilder.findNextMatch(validator1, line1, validator2);
        if (list2MatchForLine1 != null) {
            ValidatableLine match = validator2.getLine(list2MatchForLine1);
            line1.setValidationLine(match);
            validator1.increment();
            return;
        }
        Integer list1MatchForLine2 = DataTypeDiffBuilder.findNextMatch(validator2, line2, validator1);
        if (list1MatchForLine2 == null) {
            line1.setValidationLine(line2);
            validator2.increment();
        } else {
            PlaceHolderLine placeholder = validator2.insertMismatchPlaceholder(validator1.getMarkerPosition(), line1);
            line1.setValidationLine(placeholder);
        }
        validator1.increment();
    }

    private static Integer findNextMatch(DiffLinesValidator source, ValidatableLine sourceLine, DiffLinesValidator other) {
        Integer index = other.findNextMatch(sourceLine);
        if (index == null) {
            return null;
        }
        int start = source.indexOf(sourceLine) + 1;
        int end = Math.min(source.size(), index);
        for (int i = start; i < end; ++i) {
            ValidatableLine nextOther = other.getLine(i);
            ValidatableLine nextSource = source.getLine(i);
            if (!nextSource.matches(nextOther)) continue;
            return null;
        }
        return index;
    }

    private static void removeExcessEmptyRows(DiffLines leftLines, DiffLines rightLines) {
        DiffLines newLeftLines = leftLines.createEmptyClone();
        DiffLines newRightLines = rightLines.createEmptyClone();
        leftLines.removeLeadingEmptyRows();
        rightLines.removeLeadingEmptyRows();
        int end = Math.min(leftLines.size(), rightLines.size());
        DataTypeDiffBuilder.condenseSharedRange(leftLines, rightLines, newLeftLines, newRightLines, 0, end);
        DataTypeDiffBuilder.copyRealLines(leftLines, newLeftLines, end);
        DataTypeDiffBuilder.copyRealLines(rightLines, newRightLines, end);
        leftLines.installNewLines(newLeftLines);
        rightLines.installNewLines(newRightLines);
    }

    private static void condenseSharedRange(DiffLines left, DiffLines right, DiffLines newLeft, DiffLines newRight, int start, int end) {
        for (int i = start; i < end; ++i) {
            ValidatableLine line2;
            ValidatableLine line1 = (ValidatableLine)left.get(i);
            if (line1.matches(line2 = (ValidatableLine)right.get(i))) {
                DataTypeDiffBuilder.copyLine(left, newLeft, i);
                DataTypeDiffBuilder.copyLine(right, newRight, i);
                continue;
            }
            int endOfRange = DataTypeDiffBuilder.findEndOfDistinctLines(left, right, i);
            DataTypeDiffBuilder.condenseSubRange(left, right, newLeft, newRight, i, endOfRange);
            i = endOfRange - 1;
        }
    }

    private static int findEndOfDistinctLines(DiffLines left, DiffLines right, int start) {
        int end = Math.min(left.size(), right.size());
        for (int i = start; i < end; ++i) {
            ValidatableLine line2;
            ValidatableLine line1 = (ValidatableLine)left.get(i);
            if (!line1.matches(line2 = (ValidatableLine)right.get(i))) continue;
            return i;
        }
        return end;
    }

    private static void condenseSubRange(DiffLines leftSource, DiffLines rightSource, DiffLines leftDestination, DiffLines rightDestination, int start, int end) {
        int safeEndIndex = Math.min(end, leftSource.size());
        DataTypeDiffBuilder.copyRealLines(leftSource, leftDestination, start, safeEndIndex);
        safeEndIndex = Math.min(end, rightSource.size());
        DataTypeDiffBuilder.copyRealLines(rightSource, rightDestination, start, safeEndIndex);
        DataTypeDiffBuilder.padSmaller(leftDestination, rightDestination);
    }

    private static void copyLine(DiffLines from, DiffLines to, int index) {
        ValidatableLine line = (ValidatableLine)from.get(index);
        if (line instanceof PlaceHolderLine) {
            throw new AssertException("copyLine() is meant to copy only real lines, not placeholders");
        }
        to.add(line);
    }

    private static void copyRealLines(DiffLines from, DiffLines to, int offset) {
        DataTypeDiffBuilder.copyRealLines(from, to, offset, from.size());
    }

    private static void copyRealLines(DiffLines from, DiffLines to, int start, int end) {
        for (int i = start; i < end; ++i) {
            ValidatableLine line = (ValidatableLine)from.get(i);
            if (line instanceof PlaceHolderLine) continue;
            to.add(line);
        }
    }

    private static void padSmaller(DiffLines leftDestination, DiffLines rightDestination) {
        DiffLines smallerList = null;
        DiffLines largerList = null;
        int sizeDifference = 0;
        int length = Math.min(leftDestination.size(), rightDestination.size());
        if (leftDestination.size() == length) {
            smallerList = leftDestination;
            largerList = rightDestination;
            sizeDifference = rightDestination.size() - leftDestination.size();
        } else {
            smallerList = rightDestination;
            largerList = leftDestination;
            sizeDifference = leftDestination.size() - rightDestination.size();
        }
        for (int i = 0; i < sizeDifference; ++i) {
            int size = smallerList.size();
            ValidatableLine oppositeLine = (ValidatableLine)largerList.get(size);
            smallerList.insertPlaceholder(oppositeLine);
        }
    }

    private static void highlightDiffLineDiferences(DiffLines left, DiffLines right) {
        DataTypeDiffBuilder.highlightDifferences(left, right);
    }

    public static void highlightDifferences(List<ValidatableLine> left, List<ValidatableLine> right) {
        if (left.size() != right.size()) {
            throw new IllegalArgumentException("Line list size must be the same");
        }
        int sharedLength = Math.min(left.size(), right.size());
        for (int i = 0; i < sharedLength; ++i) {
            ValidatableLine line = left.get(i);
            ValidatableLine otherLine = right.get(i);
            line.setValidationLine(otherLine);
        }
    }
}

