/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.pcode.PcodeFormatter;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.PcodeFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PcodeFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "PCode";
    private static final String GROUP_TITLE = "Pcode Field";
    public static final String MAX_DISPLAY_LINES_MSG = "Pcode Field.Maximum Lines To Display";
    public static final String DISPLAY_RAW_PCODE = "Pcode Field.Display Raw Pcode";
    public static final int MAX_DISPLAY_LINES = 30;
    private PcodeFormatter formatter;

    public PcodeFieldFactory() {
        super(FIELD_NAME);
        this.setWidth(300);
    }

    public PcodeFieldFactory(String name, FieldFormatModel model, HighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        super(name, model, highlightProvider, displayOptions, fieldOptions);
        this.setWidth(300);
        this.color = displayOptions.getColor(OptionsGui.BYTES.getColorOptionName(), OptionsGui.BYTES.getDefaultColor());
        this.style = displayOptions.getInt(OptionsGui.BYTES.getStyleOptionName(), -1);
        this.formatter = new PcodeFormatter();
        this.setColors(displayOptions);
        this.setOptions(fieldOptions);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel myModel, HighlightProvider highlightProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new PcodeFieldFactory(FIELD_NAME, myModel, highlightProvider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        ArrayList<TextFieldElement> elements = new ArrayList<TextFieldElement>();
        List<AttributedString> pcodeListing = this.formatter.toAttributedStrings(instr.getProgram(), instr.getPcode(true));
        int lineCnt = pcodeListing.size();
        for (int i = 0; i < lineCnt; ++i) {
            elements.add(new TextFieldElement(pcodeListing.get(i), i, 0));
        }
        if (elements.size() > 0) {
            FieldElement[] textElements = elements.toArray(new FieldElement[elements.size()]);
            return ListingTextField.createMultilineTextField(this, proxy, textElements, this.startX + varWidth, this.width, Integer.MAX_VALUE, this.hlProvider);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof PcodeFieldLocation) {
            return new FieldLocation(index, fieldNum, ((PcodeFieldLocation)loc).getRow(), ((PcodeFieldLocation)loc).getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField listingField) {
        ProxyObj<?> proxy = listingField.getProxy();
        Object obj = proxy.getObject();
        if (!(obj instanceof Instruction)) {
            return null;
        }
        if (row < 0 || col < 0) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        Program program = instr.getProgram();
        List<AttributedString> attributedStrings = this.formatter.toAttributedStrings(program, instr.getPcode(true));
        ArrayList<String> strings = new ArrayList<String>(attributedStrings.size());
        for (AttributedString attributedString : attributedStrings) {
            strings.add(attributedString.getText());
        }
        return new PcodeFieldLocation(program, instr.getMinAddress(), strings, row, col);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return CodeUnit.class.isAssignableFrom(proxyObjectClass) && (category == 4 || category == 5);
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        this.formatter.setFontMetrics(this.getMetrics());
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (options.getName().equals("Listing Fields") && (optionName.equals(MAX_DISPLAY_LINES_MSG) || optionName.equals(DISPLAY_RAW_PCODE))) {
            this.setOptions(options);
            this.model.update();
        }
    }

    private void setColors(Options options) {
        this.formatter.setColor(options.getColor(OptionsGui.ADDRESS.getColorOptionName(), OptionsGui.ADDRESS.getDefaultColor()), options.getColor(OptionsGui.REGISTERS.getColorOptionName(), OptionsGui.REGISTERS.getDefaultColor()), options.getColor(OptionsGui.CONSTANT.getColorOptionName(), OptionsGui.CONSTANT.getDefaultColor()), options.getColor(OptionsGui.LABELS_LOCAL.getColorOptionName(), OptionsGui.LABELS_LOCAL.getDefaultColor()));
        this.formatter.setFontMetrics(this.getMetrics());
    }

    private void setOptions(Options fieldOptions) {
        fieldOptions.registerOption(MAX_DISPLAY_LINES_MSG, (Object)30, null, "Max number line of pcode to display");
        fieldOptions.registerOption(DISPLAY_RAW_PCODE, (Object)false, null, "Display raw pcode (for debugging)");
        int maxDisplayLines = fieldOptions.getInt(MAX_DISPLAY_LINES_MSG, 30);
        boolean displayRaw = fieldOptions.getBoolean(DISPLAY_RAW_PCODE, false);
        this.formatter.setOptions(maxDisplayLines, displayRaw);
    }
}

